/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Map;
import org.asynchttpclient.HttpResponseHeaders;

public class NettyResponseHeaders
extends HttpResponseHeaders {
    private final HttpHeaders responseHeaders;
    private final HttpHeaders trailingHeaders;
    private final HttpHeaders headers;

    public NettyResponseHeaders(HttpHeaders responseHeaders) {
        this(responseHeaders, null);
    }

    public NettyResponseHeaders(HttpHeaders responseHeaders, HttpHeaders traillingHeaders) {
        super(traillingHeaders != null);
        this.responseHeaders = responseHeaders;
        this.trailingHeaders = traillingHeaders;
        this.headers = this.computerHeaders();
    }

    private HttpHeaders computerHeaders() {
        DefaultHttpHeaders h = new DefaultHttpHeaders();
        for (Map.Entry header : this.responseHeaders) {
            h.add((String)header.getKey(), header.getValue());
        }
        if (this.trailingHeaders != null) {
            for (Map.Entry header : this.trailingHeaders) {
                h.add((String)header.getKey(), header.getValue());
            }
        }
        return h;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }
}

