/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import io.netty.channel.Channel;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import java.nio.channels.ClosedChannelException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.handler.ProgressAsyncHandler;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelState;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.future.StackTraceInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressListener
implements ChannelProgressiveFutureListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgressListener.class);
    private final AsyncHandler<?> asyncHandler;
    private final NettyResponseFuture<?> future;
    private final boolean notifyHeaders;
    private final long expectedTotal;
    private long lastProgress = 0L;

    public ProgressListener(AsyncHandler<?> asyncHandler, NettyResponseFuture<?> future, boolean notifyHeaders, long expectedTotal) {
        this.asyncHandler = asyncHandler;
        this.future = future;
        this.notifyHeaders = notifyHeaders;
        this.expectedTotal = expectedTotal;
    }

    private boolean abortOnThrowable(Throwable cause, Channel channel) {
        if (cause != null && this.future.getChannelState() != ChannelState.NEW) {
            if (cause instanceof IllegalStateException || cause instanceof ClosedChannelException || StackTraceInspector.recoverOnReadOrWriteException(cause)) {
                LOGGER.debug(cause.getMessage(), cause);
                Channels.silentlyCloseChannel(channel);
            } else {
                this.future.abort(cause);
            }
            return true;
        }
        return false;
    }

    public void operationComplete(ChannelProgressiveFuture cf) {
        if (!this.abortOnThrowable(cf.cause(), cf.channel())) {
            boolean startPublishing;
            this.future.touch();
            boolean bl = startPublishing = !this.future.getInAuth().get() && !this.future.getInProxyAuth().get();
            if (startPublishing && this.asyncHandler instanceof ProgressAsyncHandler) {
                ProgressAsyncHandler progressAsyncHandler = (ProgressAsyncHandler)this.asyncHandler;
                if (this.notifyHeaders) {
                    progressAsyncHandler.onHeadersWritten();
                } else {
                    progressAsyncHandler.onContentWritten();
                }
            }
        }
    }

    public void operationProgressed(ChannelProgressiveFuture f, long progress, long total) {
        this.future.touch();
        if (!this.notifyHeaders && this.asyncHandler instanceof ProgressAsyncHandler) {
            long lastLastProgress = this.lastProgress;
            this.lastProgress = progress;
            if (total < 0L) {
                total = this.expectedTotal;
            }
            ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteProgress(progress - lastLastProgress, progress, total);
        }
    }
}

