/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler.intercept;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.util.List;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.ChannelState;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.ntlm.NtlmEngine;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.spnego.SpnegoEngine;
import org.asynchttpclient.spnego.SpnegoEngineException;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.AuthenticatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unauthorized401Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Unauthorized401Interceptor.class);
    private final ChannelManager channelManager;
    private final NettyRequestSender requestSender;

    public Unauthorized401Interceptor(ChannelManager channelManager, NettyRequestSender requestSender) {
        this.channelManager = channelManager;
        this.requestSender = requestSender;
    }

    public boolean exitAfterHandling401(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm, ProxyServer proxyServer, HttpRequest httpRequest) {
        if (realm == null) {
            LOGGER.info("Can't handle 401 as there's no realm");
            return false;
        }
        if (future.getInAuth().getAndSet(true)) {
            LOGGER.info("Can't handle 401 as auth was already performed");
            return false;
        }
        List wwwAuthHeaders = response.headers().getAll("WWW-Authenticate");
        if (wwwAuthHeaders.isEmpty()) {
            LOGGER.info("Can't handle 401 as response doesn't contain WWW-Authenticate headers");
            return false;
        }
        future.setChannelState(ChannelState.NEW);
        HttpHeaders requestHeaders = new DefaultHttpHeaders(false).add(request.getHeaders());
        switch (realm.getScheme()) {
            case BASIC: {
                if (AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "Basic") == null) {
                    LOGGER.info("Can't handle 401 with Basic realm as WWW-Authenticate headers don't match");
                    return false;
                }
                if (realm.isUsePreemptiveAuth()) {
                    LOGGER.info("Can't handle 401 with Basic realm as auth was preemptive and already performed");
                    return false;
                }
                Realm newBasicRealm = Dsl.realm(realm).setUsePreemptiveAuth(true).build();
                future.setRealm(newBasicRealm);
                break;
            }
            case DIGEST: {
                String digestHeader = AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "Digest");
                if (digestHeader == null) {
                    LOGGER.info("Can't handle 401 with Digest realm as WWW-Authenticate headers don't match");
                    return false;
                }
                Realm newDigestRealm = Dsl.realm(realm).setUri(request.getUri()).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader(digestHeader).build();
                future.setRealm(newDigestRealm);
                break;
            }
            case NTLM: {
                String ntlmHeader = AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "NTLM");
                if (ntlmHeader == null) {
                    LOGGER.info("Can't handle 401 with NTLM realm as WWW-Authenticate headers don't match");
                    return false;
                }
                this.ntlmChallenge(ntlmHeader, request, requestHeaders, realm, future);
                Realm newNtlmRealm = Dsl.realm(realm).setUsePreemptiveAuth(true).build();
                future.setRealm(newNtlmRealm);
                break;
            }
            case KERBEROS: 
            case SPNEGO: {
                if (AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "Negotiate") == null) {
                    LOGGER.info("Can't handle 401 with Kerberos or Spnego realm as WWW-Authenticate headers don't match");
                    return false;
                }
                try {
                    this.kerberosChallenge(channel, wwwAuthHeaders, request, requestHeaders, realm, future);
                    break;
                }
                catch (SpnegoEngineException e) {
                    String ntlmHeader2 = AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "NTLM");
                    if (ntlmHeader2 != null) {
                        LOGGER.warn("Kerberos/Spnego auth failed, proceeding with NTLM");
                        this.ntlmChallenge(ntlmHeader2, request, requestHeaders, realm, future);
                        Realm newNtlmRealm2 = Dsl.realm(realm).setScheme(Realm.AuthScheme.NTLM).setUsePreemptiveAuth(true).build();
                        future.setRealm(newNtlmRealm2);
                        break;
                    }
                    this.requestSender.abort(channel, future, e);
                    return false;
                }
            }
            default: {
                throw new IllegalStateException("Invalid Authentication scheme " + (Object)((Object)realm.getScheme()));
            }
        }
        Request nextRequest = ((RequestBuilder)new RequestBuilder(future.getCurrentRequest()).setHeaders(requestHeaders)).build();
        LOGGER.debug("Sending authentication to {}", (Object)request.getUri());
        if (future.isKeepAlive() && !HttpHeaders.isTransferEncodingChunked((HttpMessage)httpRequest) && !HttpHeaders.isTransferEncodingChunked((HttpMessage)response)) {
            future.setReuseChannel(true);
            this.requestSender.drainChannelAndExecuteNextRequest(channel, future, nextRequest);
        } else {
            this.channelManager.closeChannel(channel);
            this.requestSender.sendNextRequest(nextRequest, future);
        }
        return true;
    }

    private void ntlmChallenge(String authenticateHeader, Request request, HttpHeaders requestHeaders, Realm realm, NettyResponseFuture<?> future) {
        if (authenticateHeader.equals("NTLM")) {
            String challengeHeader = NtlmEngine.INSTANCE.generateType1Msg();
            requestHeaders.set("Authorization", (Object)("NTLM " + challengeHeader));
            future.getInAuth().set(false);
        } else {
            String serverChallenge = authenticateHeader.substring("NTLM ".length()).trim();
            String challengeHeader = NtlmEngine.INSTANCE.generateType3Msg(realm.getPrincipal(), realm.getPassword(), realm.getNtlmDomain(), realm.getNtlmHost(), serverChallenge);
            requestHeaders.set("Authorization", (Object)("NTLM " + challengeHeader));
        }
    }

    private void kerberosChallenge(Channel channel, List<String> authHeaders, Request request, HttpHeaders headers, Realm realm, NettyResponseFuture<?> future) throws SpnegoEngineException {
        Uri uri = request.getUri();
        String host = request.getVirtualHost() == null ? uri.getHost() : request.getVirtualHost();
        String challengeHeader = SpnegoEngine.instance().generateToken(host);
        headers.set("Authorization", (Object)("Negotiate " + challengeHeader));
    }
}

