/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.util;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import org.asynchttpclient.netty.util.ByteBufUtils;

public class Utf8ByteBufCharsetDecoder {
    private static final ThreadLocal<Utf8ByteBufCharsetDecoder> POOL = new ThreadLocal<Utf8ByteBufCharsetDecoder>(){

        @Override
        protected Utf8ByteBufCharsetDecoder initialValue() {
            return new Utf8ByteBufCharsetDecoder();
        }
    };
    private final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    protected CharBuffer charBuffer = this.allocateCharBuffer(1024);
    private ByteBuffer splitCharBuffer;

    private static Utf8ByteBufCharsetDecoder pooledDecoder() {
        Utf8ByteBufCharsetDecoder decoder = POOL.get();
        decoder.reset();
        return decoder;
    }

    public static String decodeUtf8(ByteBuf buf) throws CharacterCodingException {
        return Utf8ByteBufCharsetDecoder.pooledDecoder().decode(buf);
    }

    public static String decodeUtf8(ByteBuf ... bufs) throws CharacterCodingException {
        return Utf8ByteBufCharsetDecoder.pooledDecoder().decode(bufs);
    }

    protected void initSplitCharBuffer() {
        if (this.splitCharBuffer == null) {
            this.splitCharBuffer = ByteBuffer.allocate(4);
        }
    }

    protected CharBuffer allocateCharBuffer(int l) {
        return CharBuffer.allocate(l);
    }

    private void ensureCapacity(int l) {
        if (this.charBuffer.position() == 0) {
            if (this.charBuffer.capacity() < l) {
                this.charBuffer = this.allocateCharBuffer(l);
            }
        } else if (this.charBuffer.remaining() < l) {
            CharBuffer newCharBuffer = this.allocateCharBuffer(this.charBuffer.position() + l);
            this.charBuffer.flip();
            newCharBuffer.put(this.charBuffer);
            this.charBuffer = newCharBuffer;
        }
    }

    public void reset() {
        this.decoder.reset();
        this.charBuffer.clear();
    }

    private static int charSize(byte firstByte) throws CharacterCodingException {
        if (firstByte >> 5 == -2 && (firstByte & 0x1E) != 0) {
            return 2;
        }
        if (firstByte >> 4 == -2) {
            return 3;
        }
        if (firstByte >> 3 == -2) {
            return 4;
        }
        throw new CharacterCodingException();
    }

    private void handleSplitCharBuffer(ByteBuffer nioBuffer, boolean endOfInput) throws CharacterCodingException {
        int missingBytes = Utf8ByteBufCharsetDecoder.charSize(this.splitCharBuffer.get(0)) - this.splitCharBuffer.position();
        if (nioBuffer.remaining() < missingBytes) {
            if (endOfInput) {
                throw new CharacterCodingException();
            }
            this.splitCharBuffer.put(nioBuffer);
        } else {
            for (int i = 0; i < missingBytes; ++i) {
                this.splitCharBuffer.put(nioBuffer.get());
            }
            this.splitCharBuffer.flip();
            CoderResult res = this.decoder.decode(this.splitCharBuffer, this.charBuffer, endOfInput && !nioBuffer.hasRemaining());
            if (res.isError()) {
                res.throwException();
            }
            this.splitCharBuffer.position(0);
        }
    }

    protected void decodePartial(ByteBuffer nioBuffer, boolean endOfInput) throws CharacterCodingException {
        if (this.splitCharBuffer != null && this.splitCharBuffer.position() > 0 && nioBuffer.hasRemaining()) {
            this.handleSplitCharBuffer(nioBuffer, endOfInput);
        }
        if (nioBuffer.hasRemaining()) {
            CoderResult res = this.decoder.decode(nioBuffer, this.charBuffer, endOfInput);
            if (res.isUnderflow()) {
                if (nioBuffer.remaining() > 0) {
                    this.initSplitCharBuffer();
                    this.splitCharBuffer.put(nioBuffer);
                }
            } else if (res.isError()) {
                res.throwException();
            }
        }
    }

    private void decode(ByteBuffer[] nioBuffers, int length) throws CharacterCodingException {
        int count = nioBuffers.length;
        for (int i = 0; i < count; ++i) {
            this.decodePartial(nioBuffers[i].duplicate(), i == count - 1);
        }
    }

    private void decodeSingleNioBuffer(ByteBuffer nioBuffer, int length) throws CharacterCodingException {
        CoderResult res = this.decoder.decode(nioBuffer, this.charBuffer, true);
        if (res.isError()) {
            res.throwException();
        }
    }

    public String decode(ByteBuf buf) throws CharacterCodingException {
        if (buf.isDirect()) {
            return buf.toString(StandardCharsets.UTF_8);
        }
        int length = buf.readableBytes();
        this.ensureCapacity(length);
        if (buf.nioBufferCount() == 1) {
            this.decodeSingleNioBuffer(buf.internalNioBuffer(buf.readerIndex(), length).duplicate(), length);
        } else {
            this.decode(buf.nioBuffers(), buf.readableBytes());
        }
        return this.charBuffer.flip().toString();
    }

    public String decode(ByteBuf ... bufs) throws CharacterCodingException {
        if (bufs.length == 1) {
            return this.decode(bufs[0]);
        }
        int totalSize = 0;
        int totalNioBuffers = 0;
        boolean withoutArray = false;
        for (ByteBuf buf : bufs) {
            if (!buf.hasArray()) {
                withoutArray = true;
                break;
            }
            totalSize += buf.readableBytes();
            totalNioBuffers += buf.nioBufferCount();
        }
        if (withoutArray) {
            return ByteBufUtils.decodeNonOptimized(StandardCharsets.UTF_8, bufs);
        }
        ByteBuffer[] nioBuffers = new ByteBuffer[totalNioBuffers];
        int i = 0;
        for (ByteBuf buf : bufs) {
            for (ByteBuffer nioBuffer : buf.nioBuffers()) {
                nioBuffers[i++] = nioBuffer;
            }
        }
        this.ensureCapacity(totalSize);
        this.decode(nioBuffers, totalSize);
        return this.charBuffer.flip().toString();
    }
}

