/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.registry;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.extras.registry.AsyncHttpClientImplException;
import org.asynchttpclient.extras.registry.AsyncHttpClientRegistry;
import org.asynchttpclient.extras.registry.AsyncImplHelper;

public class AsyncHttpClientRegistryImpl
implements AsyncHttpClientRegistry {
    private static ConcurrentMap<String, AsyncHttpClient> asyncHttpClientMap = new ConcurrentHashMap<String, AsyncHttpClient>();
    private static volatile AsyncHttpClientRegistry _instance;
    private static Lock lock;

    public static AsyncHttpClientRegistry getInstance() {
        if (_instance == null) {
            lock.lock();
            try {
                if (_instance == null) {
                    Class<AsyncHttpClient> asyncHttpClientRegistryImplClass = AsyncImplHelper.getAsyncImplClass("org.async.http.client.registry.impl");
                    _instance = asyncHttpClientRegistryImplClass != null ? (AsyncHttpClientRegistry)asyncHttpClientRegistryImplClass.newInstance() : new AsyncHttpClientRegistryImpl();
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new AsyncHttpClientImplException("Couldn't instantiate AsyncHttpClientRegistry : " + e.getMessage(), e);
            }
            finally {
                lock.unlock();
            }
        }
        return _instance;
    }

    @Override
    public AsyncHttpClient get(String clientName) {
        return (AsyncHttpClient)asyncHttpClientMap.get(clientName);
    }

    @Override
    public AsyncHttpClient addOrReplace(String name, AsyncHttpClient ahc) {
        return asyncHttpClientMap.put(name, ahc);
    }

    @Override
    public boolean registerIfNew(String name, AsyncHttpClient ahc) {
        return asyncHttpClientMap.putIfAbsent(name, ahc) == null;
    }

    @Override
    public boolean unregister(String name) {
        return asyncHttpClientMap.remove(name) != null;
    }

    @Override
    public Set<String> getAllRegisteredNames() {
        return asyncHttpClientMap.keySet();
    }

    @Override
    public void clearAllInstances() {
        asyncHttpClientMap.clear();
    }

    static {
        lock = new ReentrantLock();
    }
}

