/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.managerAPI;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.NewChannelListener;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.agi.AgiChannelActivityDial;
import org.asteriskjava.pbx.asterisk.wrap.events.BridgeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.HangupEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.LinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.UnlinkEvent;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.managerAPI.EventListenerBaseClass;
import org.asteriskjava.pbx.internal.managerAPI.HoldAtAgi;
import org.asteriskjava.pbx.internal.managerAPI.OriginateResult;
import org.asteriskjava.pbx.internal.managerAPI.OriginateToExtension;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class Dial
extends EventListenerBaseClass {
    private static final Log logger = LogFactory.getLog(Dial.class);
    private final OriginateResult[] result = new OriginateResult[2];
    private CountDownLatch _latch;

    public Dial(String descriptiveName) {
        super(descriptiveName, PBXFactory.getActivePBX());
    }

    /*
     * Loose catch block
     */
    public OriginateResult[] dial(NewChannelListener listener, EndPoint localHandset, EndPoint targetEndPoint, String dialContext, CallerID callerID, boolean hideCallerId, Map<String, String> channelVarsToSet, String dialOptions) throws PBXException {
        PBX pbx = PBXFactory.getActivePBX();
        try {
            try (OriginateToExtension originate = new OriginateToExtension(listener);){
                OriginateResult trcResult;
                this.startListener();
                this.result[0] = trcResult = originate.originate(localHandset, pbx.getExtensionAgi(), true, ((AsteriskPBX)pbx).getManagementContext(), callerID, null, hideCallerId, channelVarsToSet);
                if (trcResult.isSuccess()) {
                    try {
                        if (targetEndPoint instanceof HoldAtAgi) {
                            if (trcResult.getChannel().waitForChannelToReachAgi(30L, TimeUnit.SECONDS)) {
                                System.out.println("Call is in agi");
                            } else {
                                System.out.println("Call never reached agi");
                            }
                        } else {
                            this._latch = new CountDownLatch(1);
                            trcResult.getChannel().setCurrentActivityAction(new AgiChannelActivityDial(targetEndPoint.getFullyQualifiedName(), dialOptions));
                            this._latch.await(30L, TimeUnit.SECONDS);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                OriginateResult[] originateResultArray = this.result;
                return originateResultArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.close();
        }
    }

    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        required.add(BridgeEvent.class);
        required.add(LinkEvent.class);
        required.add(UnlinkEvent.class);
        required.add(HangupEvent.class);
        return required;
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
        if (event instanceof BridgeEvent) {
            BridgeEvent link = (BridgeEvent)event;
            if (link.getChannel1() != null && this.result[0] != null && link.getChannel1().isSame(this.result[0].getChannel())) {
                logger.debug("Dial out bridged on " + link.getChannel1() + " to " + link.getChannel2());
                this.result[1] = new OriginateResult();
                this.result[1].setChannelData(link.getChannel2());
                this._latch.countDown();
            }
        } else if (event instanceof HangupEvent) {
            HangupEvent hangup = (HangupEvent)event;
            Channel hangupChannel = hangup.getChannel();
            if (logger.isDebugEnabled()) {
                logger.debug("hangup :" + hangupChannel);
                logger.debug("channel 0:" + this.result[0]);
                logger.debug("channel 1:" + this.result[1]);
            }
            if (this.result[0] != null && this.result[0].isSuccess() && hangupChannel.isSame(this.result[0].getChannel()) && this._latch != null) {
                this._latch.countDown();
            }
        }
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.NORMAL;
    }
}

