/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.pbx.Activity;
import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.ActivityStatusEnum;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.agi.ActivityAgi;
import org.asteriskjava.pbx.agi.ActivityArrivalListener;
import org.asteriskjava.pbx.asterisk.wrap.actions.OriginateAction;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class DialLocalToAgiActivity
implements Runnable,
Activity {
    private EndPoint from;
    private CallerID fromCallerID;
    private Thread thread;
    private final Log logger = LogFactory.getLog(this.getClass());
    CountDownLatch latch = new CountDownLatch(1);
    private List<Channel> channels = new LinkedList<Channel>();
    private ActivityCallback<DialLocalToAgiActivity> callback;
    private Map<String, String> channelVarsToSet;

    public DialLocalToAgiActivity(EndPoint from, CallerID fromCallerID, ActivityCallback<DialLocalToAgiActivity> callback, Map<String, String> channelVarsToSet) {
        this.from = from;
        this.fromCallerID = fromCallerID;
        this.callback = callback;
        this.channelVarsToSet = channelVarsToSet;
        this.thread = new Thread((Runnable)this, "Dial " + from + " to AGI");
        this.thread.start();
    }

    @Override
    public void run() {
        this.logger.debug("*******************************************************************************");
        this.logger.info("***********                    begin dial local to AGI                  ****************");
        this.logger.debug("***********                                                      ****************");
        this.logger.debug("*******************************************************************************");
        AsteriskSettings settings = PBXFactory.getActiveProfile();
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        OriginateAction originate = new OriginateAction();
        originate.setEndPoint(this.from);
        originate.setContext(settings.getManagementContext());
        originate.setExten(pbx.getExtensionAgi());
        originate.setPriority(1);
        originate.setCallerId(this.fromCallerID);
        originate.setTimeout(30000L);
        HashMap<String, String> myVars = new HashMap<String, String>();
        if (this.channelVarsToSet != null) {
            myVars.putAll(this.channelVarsToSet);
        }
        originate.setVariables(myVars);
        ActivityArrivalListener listener = new ActivityArrivalListener(){

            @Override
            public void channelArrived(Channel channel) {
                DialLocalToAgiActivity.this.channels.add(channel);
                if (DialLocalToAgiActivity.this.isSuccess()) {
                    DialLocalToAgiActivity.this.latch.countDown();
                }
            }
        };
        try (AutoCloseable closeable = ActivityAgi.addArrivalListener(originate, listener);){
            ManagerResponse response = pbx.sendAction(originate, 5000);
            if (response.getResponse().compareToIgnoreCase("Success") != 0) {
                this.callback.progress(this, ActivityStatusEnum.FAILURE, ActivityStatusEnum.FAILURE.getDefaultMessage());
            } else if (this.latch.await(5L, TimeUnit.SECONDS)) {
                this.callback.progress(this, ActivityStatusEnum.SUCCESS, ActivityStatusEnum.SUCCESS.getDefaultMessage());
            } else {
                this.callback.progress(this, ActivityStatusEnum.FAILURE, ActivityStatusEnum.FAILURE.getDefaultMessage());
            }
        }
        catch (Exception e) {
            this.logger.error(e, e);
            this.callback.progress(this, ActivityStatusEnum.FAILURE, ActivityStatusEnum.FAILURE.getDefaultMessage());
        }
    }

    public void abort(String reason) {
        this.logger.warn("Aborting originate ");
        for (Channel channel : this.channels) {
            PBX pbx = PBXFactory.getActivePBX();
            try {
                pbx.hangup(channel);
            }
            catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                this.logger.error(e, e);
            }
        }
        this.latch.countDown();
    }

    @Override
    public Throwable getLastException() {
        return null;
    }

    @Override
    public boolean isSuccess() {
        return this.channels.size() == 2;
    }

    public Channel getChannel1() {
        return this.channels.get(0);
    }

    public Channel getChannel2() {
        return this.channels.get(1);
    }
}

