/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.jodatime.api;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.jodatime.error.ShouldBeAfter;
import org.assertj.jodatime.error.ShouldBeAfterOrEqualsTo;
import org.assertj.jodatime.error.ShouldBeBefore;
import org.assertj.jodatime.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.jodatime.error.ShouldHaveDayOfMonthEqualTo;
import org.assertj.jodatime.error.ShouldHaveMonthOfYearEqualTo;
import org.assertj.jodatime.error.ShouldHaveYearEqualTo;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class LocalDateAssert
extends AbstractAssert<LocalDateAssert, LocalDate> {
    public static final String NULL_LOCAL_DATE_PARAMETER_MESSAGE = "The LocalDate to compare actual with should not be null";

    protected LocalDateAssert(Class<LocalDateAssert> selfType, LocalDate actual) {
        super((Object)actual, selfType);
    }

    protected LocalDate getActual() {
        return (LocalDate)this.actual;
    }

    public LocalDateAssert hasYear(int expectedYear) {
        this.isNotNull();
        if (((LocalDate)this.actual).getYear() != expectedYear) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveYearEqualTo.shouldHaveYearEqualTo(this.actual, ((LocalDate)this.actual).getYear(), expectedYear));
        }
        return this;
    }

    public LocalDateAssert hasMonthOfYear(int expectedMonthOfYear) {
        this.isNotNull();
        if (((LocalDate)this.actual).getMonthOfYear() != expectedMonthOfYear) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveMonthOfYearEqualTo.shouldHaveMonthOfYearEqualTo(this.actual, ((LocalDate)this.actual).getMonthOfYear(), expectedMonthOfYear));
        }
        return this;
    }

    public LocalDateAssert hasDayOfMonth(int expectedDayOfMonth) {
        this.isNotNull();
        if (((LocalDate)this.actual).getDayOfMonth() != expectedDayOfMonth) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveDayOfMonthEqualTo.shouldHaveDayOfMonthEqualTo(this.actual, ((LocalDate)this.actual).getDayOfMonth(), expectedDayOfMonth));
        }
        return this;
    }

    public LocalDateAssert isBefore(LocalDate other) {
        this.isNotNull();
        LocalDateAssert.assertLocalDateParameterIsNotNull(other);
        if (!((LocalDate)this.actual).isBefore((ReadablePartial)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return this;
    }

    public LocalDateAssert isBefore(String LocalDateAsString) {
        LocalDateAssert.assertLocalDateAsStringParameterIsNotNull(LocalDateAsString);
        return this.isBefore(new LocalDate((Object)LocalDateAsString));
    }

    public LocalDateAssert isBeforeOrEqualTo(LocalDate other) {
        this.isNotNull();
        LocalDateAssert.assertLocalDateParameterIsNotNull(other);
        if (((LocalDate)this.actual).isAfter((ReadablePartial)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return this;
    }

    public LocalDateAssert isBeforeOrEqualTo(String LocalDateAsString) {
        LocalDateAssert.assertLocalDateAsStringParameterIsNotNull(LocalDateAsString);
        return this.isBeforeOrEqualTo(new LocalDate((Object)LocalDateAsString));
    }

    public LocalDateAssert isAfterOrEqualTo(LocalDate other) {
        this.isNotNull();
        LocalDateAssert.assertLocalDateParameterIsNotNull(other);
        if (((LocalDate)this.actual).isBefore((ReadablePartial)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return this;
    }

    public LocalDateAssert isAfterOrEqualTo(String LocalDateAsString) {
        LocalDateAssert.assertLocalDateAsStringParameterIsNotNull(LocalDateAsString);
        return this.isAfterOrEqualTo(new LocalDate((Object)LocalDateAsString));
    }

    public LocalDateAssert isAfter(LocalDate other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        LocalDateAssert.assertLocalDateParameterIsNotNull(other);
        if (!((LocalDate)this.actual).isAfter((ReadablePartial)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return this;
    }

    public LocalDateAssert isAfter(String localDateAsString) {
        LocalDateAssert.assertLocalDateAsStringParameterIsNotNull(localDateAsString);
        return this.isAfter(new LocalDate((Object)localDateAsString));
    }

    public LocalDateAssert isEqualTo(String localDateString) {
        LocalDateAssert.assertLocalDateAsStringParameterIsNotNull(localDateString);
        return (LocalDateAssert)this.isEqualTo(new LocalDate((Object)localDateString));
    }

    public LocalDateAssert isNotEqualTo(String localDateAsString) {
        LocalDateAssert.assertLocalDateAsStringParameterIsNotNull(localDateAsString);
        return (LocalDateAssert)this.isNotEqualTo(new LocalDate((Object)localDateAsString));
    }

    public LocalDateAssert isIn(String ... localDatesAsString) {
        this.checkIsNotNullAndNotEmpty(localDatesAsString);
        return (LocalDateAssert)this.isIn(LocalDateAssert.convertToLocalDateArray(localDatesAsString));
    }

    public LocalDateAssert isNotIn(String ... localDatesAsString) {
        this.checkIsNotNullAndNotEmpty(localDatesAsString);
        return (LocalDateAssert)this.isNotIn(LocalDateAssert.convertToLocalDateArray(localDatesAsString));
    }

    private static Object[] convertToLocalDateArray(String ... localDatesAsString) {
        Object[] dates = new LocalDate[localDatesAsString.length];
        for (int i = 0; i < localDatesAsString.length; ++i) {
            dates[i] = new LocalDate((Object)localDatesAsString[i]);
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The given LocalDate array should not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("The given LocalDate array should not be empty");
        }
    }

    private static void assertLocalDateAsStringParameterIsNotNull(String localDateAsString) {
        if (localDateAsString == null) {
            throw new IllegalArgumentException("The String representing the LocalDate to compare actual with should not be null");
        }
    }

    private static void assertLocalDateParameterIsNotNull(LocalDate other) {
        if (other == null) {
            throw new IllegalArgumentException(NULL_LOCAL_DATE_PARAMETER_MESSAGE);
        }
    }
}

