/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Time;
import java.text.ParseException;
import java.time.LocalTime;
import java.util.Calendar;

public class TimeValue
implements Comparable<TimeValue> {
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final int nanoSeconds;
    private static final String TIME_FORMAT = "\\d\\d:\\d\\d";
    private static final String TIME_FORMAT_WITH_SECONDS = "\\d\\d:\\d\\d:\\d\\d";
    private static final String TIME_FORMAT_WITH_NANO = "\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d\\d\\d\\d\\d\\d\\d";

    public static TimeValue of(int hours, int minutes, int seconds, int nanoSeconds) {
        return new TimeValue(hours, minutes, seconds, nanoSeconds);
    }

    public static TimeValue of(int hours, int minutes, int seconds) {
        return new TimeValue(hours, minutes, seconds);
    }

    public static TimeValue of(int hours, int minutes) {
        return new TimeValue(hours, minutes);
    }

    public static TimeValue parse(String time) throws ParseException {
        return new TimeValue(time);
    }

    public static TimeValue from(Time time) {
        return new TimeValue(time);
    }

    public static TimeValue from(Calendar calendar) {
        return new TimeValue(calendar);
    }

    public static TimeValue from(LocalTime localTime) {
        return new TimeValue(localTime);
    }

    public static TimeValue now() {
        return TimeValue.from(Calendar.getInstance());
    }

    public TimeValue(int hours, int minutes, int seconds, int nanoSeconds) {
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.nanoSeconds = nanoSeconds;
    }

    public TimeValue(int hours, int minutes, int seconds) {
        this(hours, minutes, seconds, 0);
    }

    public TimeValue(int hours, int minutes) {
        this(hours, minutes, 0, 0);
    }

    public TimeValue(String time) throws ParseException {
        if (time == null) {
            throw new NullPointerException("time should be not null");
        }
        if (time.matches(TIME_FORMAT)) {
            this.hours = Integer.parseInt(time.substring(0, 2));
            this.minutes = Integer.parseInt(time.substring(3));
            this.seconds = 0;
            this.nanoSeconds = 0;
        } else if (time.matches(TIME_FORMAT_WITH_SECONDS)) {
            this.hours = Integer.parseInt(time.substring(0, 2));
            this.minutes = Integer.parseInt(time.substring(3, 5));
            this.seconds = Integer.parseInt(time.substring(6));
            this.nanoSeconds = 0;
        } else if (time.matches(TIME_FORMAT_WITH_NANO)) {
            this.hours = Integer.parseInt(time.substring(0, 2));
            this.minutes = Integer.parseInt(time.substring(3, 5));
            this.seconds = Integer.parseInt(time.substring(6, 8));
            this.nanoSeconds = Integer.parseInt(time.substring(9));
        } else {
            throw new ParseException("time must respect hh:mm, hh:mm:ss or hh:mm:ss.nnnnnnnnn format", time.length());
        }
    }

    public TimeValue(Time time) {
        if (time == null) {
            throw new NullPointerException("time should be not null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time.getTime());
        this.hours = calendar.get(11);
        this.minutes = calendar.get(12);
        this.seconds = calendar.get(13);
        this.nanoSeconds = calendar.get(14) * 1000000;
    }

    public TimeValue(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("time should be not null");
        }
        this.hours = calendar.get(11);
        this.minutes = calendar.get(12);
        this.seconds = calendar.get(13);
        this.nanoSeconds = calendar.get(14) * 1000000;
    }

    public TimeValue(LocalTime localTime) {
        if (localTime == null) {
            throw new NullPointerException("time should be not null");
        }
        this.hours = localTime.getHour();
        this.minutes = localTime.getMinute();
        this.seconds = localTime.getSecond();
        this.nanoSeconds = localTime.getNano();
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getNanoSeconds() {
        return this.nanoSeconds;
    }

    public String toString() {
        return String.format("%02d:%02d:%02d.%09d", this.hours, this.minutes, this.seconds, this.nanoSeconds);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeValue) {
            TimeValue timeValue = (TimeValue)obj;
            return this.hours == timeValue.hours && this.minutes == timeValue.minutes && this.seconds == timeValue.seconds && this.nanoSeconds == timeValue.nanoSeconds;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hours;
        result = 31 * result + this.minutes;
        result = 31 * result + this.nanoSeconds;
        result = 31 * result + this.seconds;
        return result;
    }

    @Override
    public int compareTo(TimeValue other) {
        if (this.hours < other.hours) {
            return -1;
        }
        if (this.hours > other.hours) {
            return 1;
        }
        if (this.minutes < other.minutes) {
            return -1;
        }
        if (this.minutes > other.minutes) {
            return 1;
        }
        if (this.seconds < other.seconds) {
            return -1;
        }
        if (this.seconds > other.seconds) {
            return 1;
        }
        if (this.nanoSeconds < other.nanoSeconds) {
            return -1;
        }
        if (this.nanoSeconds > other.nanoSeconds) {
            return 1;
        }
        return 0;
    }

    public boolean isBefore(TimeValue time) {
        return this.compareTo(time) < 0;
    }

    public boolean isAfter(TimeValue time) {
        return this.compareTo(time) > 0;
    }

    public TimeValue move(TimeValue time) {
        int thisHours = this.hours;
        int thisMinutes = this.minutes;
        int thisSeconds = this.seconds;
        int thisNanoSeconds = this.nanoSeconds;
        int hours = time.getHours();
        int minutes = time.getMinutes();
        int seconds = time.getSeconds();
        int nanoSeconds = time.getNanoSeconds();
        if (nanoSeconds >= 0 || thisNanoSeconds >= -nanoSeconds) {
            thisNanoSeconds += nanoSeconds;
        } else {
            thisNanoSeconds += 1000000000 + nanoSeconds;
            --seconds;
        }
        if (seconds > 0 && thisSeconds + seconds >= 60) {
            thisSeconds += seconds - 60;
            ++minutes;
        } else if (seconds >= 0 || thisSeconds >= -seconds) {
            thisSeconds += seconds;
        } else {
            thisSeconds += 60 + seconds;
            --minutes;
        }
        if (minutes > 0 && thisMinutes + minutes >= 60) {
            thisMinutes += minutes - 60;
            ++hours;
        } else if (minutes >= 0 || thisMinutes >= -minutes) {
            thisMinutes += minutes;
        } else {
            thisMinutes += 60 + minutes;
            --hours;
        }
        return TimeValue.of(thisHours += hours, thisMinutes, thisSeconds, thisNanoSeconds);
    }

    public TimeValue reverse() {
        return TimeValue.of(-this.getHours(), -this.getMinutes(), -this.getSeconds(), -this.getNanoSeconds());
    }
}

