/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.output;

import java.util.List;
import org.assertj.db.navigation.Position;
import org.assertj.db.navigation.PositionWithColumns;
import org.assertj.db.navigation.ToValueFromRow;
import org.assertj.db.navigation.element.RowElement;
import org.assertj.db.output.AbstractColumnOutputter;
import org.assertj.db.output.AbstractColumnValueOutputter;
import org.assertj.db.output.AbstractDbOutputter;
import org.assertj.db.output.AbstractRowValueOutputter;
import org.assertj.db.output.AbstractSubOutputter;
import org.assertj.db.output.impl.Output;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.Row;
import org.assertj.db.type.Value;
import org.assertj.db.util.Descriptions;

public abstract class AbstractRowOutputter<D extends AbstractDbData<D>, A extends AbstractDbOutputter<D, A, C, CV, R, RV>, C extends AbstractColumnOutputter<D, A, C, CV, R, RV>, CV extends AbstractColumnValueOutputter<D, A, C, CV, R, RV>, R extends AbstractRowOutputter<D, A, C, CV, R, RV>, RV extends AbstractRowValueOutputter<D, A, C, CV, R, RV>>
extends AbstractSubOutputter<D, A, R, RV, C, CV, R, RV>
implements RowElement,
ToValueFromRow<RV> {
    private final PositionWithColumns<R, RV, Value> valuePosition;
    private final Row row;

    AbstractRowOutputter(A originalDbOutputter, Class<R> selfType, Class<RV> valueType, Row row) {
        super(originalDbOutputter, selfType);
        this.row = row;
        this.valuePosition = new PositionWithColumns<R, RV, Value>((AbstractRowOutputter)selfType.cast(this), valueType){

            @Override
            protected String getDescription(int index) {
                return AbstractRowOutputter.this.getValueDescription(index);
            }
        };
    }

    @Override
    protected String getValueDescription(int index) {
        List<String> columnsNameList = this.row.getColumnsNameList();
        String columnName = columnsNameList.get(index);
        return Descriptions.getRowValueDescription(this.info, index, columnName);
    }

    @Override
    protected Position<R, RV, Value> getValuePosition() {
        return this.valuePosition;
    }

    @Override
    protected List<Value> getValuesList() {
        return this.row.getValuesList();
    }

    @Override
    public RV value(String columnName) {
        return (RV)((AbstractRowValueOutputter)((AbstractRowValueOutputter)this.valuePosition.getInstance(this.getValuesList(), this.row.getColumnsNameList(), columnName, this.row.getColumnLetterCase())).withType(this.outputType));
    }

    @Override
    protected String getOutput(Output outputType) {
        return outputType.getRowOutput(this.info, this.row);
    }
}

