/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.assertj.db.internal.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.assertj.db.internal.bytebuddy.implementation.bind.annotation.StubValue;
import org.assertj.db.internal.bytebuddy.implementation.bind.annotation.SuperCall;
import org.assertj.db.internal.bytebuddy.implementation.bind.annotation.SuperMethod;
import org.assertj.db.internal.bytebuddy.implementation.bind.annotation.This;

public class ErrorCollector {
    private static final String INTERCEPT_METHOD_NAME = "intercept";
    private static final String CLASS_NAME = ErrorCollector.class.getName();
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final LastResult lastResult = new LastResult();

    @RuntimeType
    public Object intercept(@This Object assertion, @SuperCall Callable<?> proxy, @SuperMethod(nullIfImpossible=true) Method method, @StubValue Object stub) throws Exception {
        try {
            Object result = proxy.call();
            this.lastResult.setSuccess(true);
            return result;
        }
        catch (AssertionError assertionError) {
            if (this.isNestedErrorCollectorProxyCall()) {
                throw assertionError;
            }
            this.addError((Throwable)((Object)assertionError));
            if (method != null && !method.getReturnType().isInstance(assertion)) {
                return stub;
            }
            return assertion;
        }
    }

    public void addError(Throwable error) {
        this.errors.add(error);
        this.lastResult.recordError();
    }

    public List<Throwable> errors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean wasSuccess() {
        return this.lastResult.wasSuccess();
    }

    private boolean isNestedErrorCollectorProxyCall() {
        return ErrorCollector.countErrorCollectorProxyCalls() > 1;
    }

    private static int countErrorCollectorProxyCalls() {
        int nbCalls = 0;
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (!CLASS_NAME.equals(stackTraceElement.getClassName()) || !INTERCEPT_METHOD_NAME.equals(stackTraceElement.getMethodName())) continue;
            ++nbCalls;
        }
        return nbCalls;
    }

    private static class LastResult {
        private boolean wasSuccess = true;
        private boolean errorFound = false;

        private LastResult() {
        }

        private boolean wasSuccess() {
            return this.wasSuccess;
        }

        private void recordError() {
            this.errorFound = true;
            this.wasSuccess = false;
        }

        private void setSuccess(boolean success) {
            this.errorFound |= !success;
            if (this.resolvingOutermostErrorCollectorProxyNestedCall()) {
                this.wasSuccess = !this.errorFound;
                this.errorFound = false;
            }
        }

        private boolean resolvingOutermostErrorCollectorProxyNestedCall() {
            return ErrorCollector.countErrorCollectorProxyCalls() == 1;
        }
    }
}

