/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.core.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;

public class ExternalAnnotationTracker
implements IResourceChangeListener {
    DirectoryNode tree = new DirectoryNode(null, null);
    private static ExternalAnnotationTracker singleton;

    private ExternalAnnotationTracker() {
    }

    static void start(IWorkspace workspace) {
        singleton = new ExternalAnnotationTracker();
        workspace.addResourceChangeListener(singleton);
    }

    static void shutdown(IWorkspace workspace) {
        if (singleton != null) {
            workspace.removeResourceChangeListener(singleton);
            ExternalAnnotationTracker.singleton.tree.children = null;
        }
    }

    public static void registerClassFile(IPath annotationBase, IPath relativeAnnotationPath, ClassFile classFile) {
        int baseDepth = annotationBase.segmentCount();
        if (baseDepth == 0) {
            Util.log(new IllegalArgumentException("annotationBase cannot be empty"));
        } else {
            relativeAnnotationPath = relativeAnnotationPath.addFileExtension("eea");
            DirectoryNode base = singleton.getAnnotationBase(ExternalAnnotationTracker.singleton.tree, annotationBase, baseDepth, 1);
            base.registerClassFile(relativeAnnotationPath, classFile);
        }
    }

    public static void unregisterClassFile(IPath annotationBase, IPath relativeAnnotationPath) {
        int baseDepth = annotationBase.segmentCount();
        if (baseDepth == 0) {
            Util.log(new IllegalArgumentException("annotationBase cannot be empty"));
        } else {
            relativeAnnotationPath = relativeAnnotationPath.addFileExtension("eea");
            DirectoryNode base = singleton.getAnnotationBase(ExternalAnnotationTracker.singleton.tree, annotationBase, baseDepth, 1);
            base.unregisterClassFile(relativeAnnotationPath);
        }
    }

    private DirectoryNode getAnnotationBase(DirectoryNode current, IPath annotationBase, int baseDepth, int nextDepth) {
        IPath nextHead = annotationBase.uptoSegment(nextDepth);
        Map<IPath, DirectoryNode> children = current.getChildren();
        DirectoryNode nextHeadNode = children.get(nextHead);
        if (nextHeadNode == null) {
            nextHeadNode = new DirectoryNode(current, nextHead);
            children.put(nextHead, nextHeadNode);
        }
        if (baseDepth == nextDepth) {
            return nextHeadNode;
        }
        return this.getAnnotationBase(nextHeadNode, annotationBase, baseDepth, nextDepth + 1);
    }

    @Override
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null && delta.getFullPath().isRoot() && this.tree.children != null) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                DirectoryNode directoryNode = this.tree.children.get(child.getFullPath());
                if (directoryNode != null) {
                    this.traverseForDirectories(directoryNode, child);
                }
                ++n2;
            }
        }
    }

    private void traverseForDirectories(DirectoryNode directoryNode, IResourceDelta matchedDelta) {
        if (directoryNode.classFiles != null) {
            this.traverseForClassFiles(directoryNode.classFiles, matchedDelta, matchedDelta.getFullPath().segmentCount());
        } else if (directoryNode.children != null) {
            IResourceDelta[] iResourceDeltaArray = matchedDelta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                DirectoryNode childDir = directoryNode.children.get(child.getFullPath());
                if (childDir != null) {
                    if (child.getKind() == 2) {
                        directoryNode.children.remove(child.getFullPath());
                    } else {
                        this.traverseForDirectories(childDir, child);
                    }
                }
                ++n2;
            }
        }
        if (directoryNode.isEmpty()) {
            directoryNode.parent.children.remove(matchedDelta.getFullPath());
        }
    }

    private void traverseForClassFiles(Map<IPath, ClassFile> classFiles, IResourceDelta matchedDelta, int baseDepth) {
        IResourceDelta[] iResourceDeltaArray = matchedDelta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            IPath deltaRelativePath = delta.getFullPath().removeFirstSegments(baseDepth);
            ClassFile classFile = classFiles.remove(deltaRelativePath);
            if (classFile != null) {
                try {
                    classFile.closeAndRemoveFromJarTypeCache();
                }
                catch (JavaModelException e) {
                    Util.log(e, "Failed to close ClassFile " + classFile.name);
                }
            } else {
                this.traverseForClassFiles(classFiles, delta, baseDepth);
            }
            ++n2;
        }
    }

    static class DirectoryNode {
        DirectoryNode parent;
        IPath path;
        Map<IPath, DirectoryNode> children;
        Map<IPath, ClassFile> classFiles;
        IPackageFragmentRoot modelRoot;

        public DirectoryNode(DirectoryNode parent, IPath path) {
            this.parent = parent;
            this.path = path;
        }

        Map<IPath, DirectoryNode> getChildren() {
            if (this.children == null) {
                this.children = new HashMap<IPath, DirectoryNode>();
            }
            return this.children;
        }

        void registerClassFile(IPath relativeAnnotationPath, ClassFile classFile) {
            if (this.classFiles == null) {
                this.classFiles = new HashMap<IPath, ClassFile>();
            }
            this.classFiles.put(relativeAnnotationPath, classFile);
            if (this.modelRoot == null) {
                this.modelRoot = classFile.getPackageFragmentRoot();
            }
        }

        void unregisterClassFile(IPath relativeAnnotationPath) {
            if (this.classFiles != null) {
                this.classFiles.remove(relativeAnnotationPath);
                if (this.classFiles.isEmpty() && this.parent != null) {
                    this.parent.unregisterDirectory(this);
                }
            }
        }

        void unregisterDirectory(DirectoryNode child) {
            if (this.children != null) {
                this.children.remove(child.path);
            }
            if ((this.children == null || this.children.isEmpty()) && this.parent != null) {
                this.parent.unregisterDirectory(this);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.classFiles != null) {
                buf.append("annotation base ");
            }
            buf.append("directory\n");
            if (this.children != null) {
                buf.append("\twith ").append(this.children.size()).append(" children\n");
            }
            buf.append("\t#classFiles: ").append(this.numClassFiles());
            return buf.toString();
        }

        int numClassFiles() {
            if (this.classFiles != null) {
                return this.classFiles.size();
            }
            int count = 0;
            if (this.children != null) {
                for (DirectoryNode child : this.children.values()) {
                    count += child.numClassFiles();
                }
            }
            return count;
        }

        boolean isEmpty() {
            return !(this.children != null && !this.children.isEmpty() || this.classFiles != null && !this.classFiles.isEmpty());
        }
    }
}

