/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.IUIBuildMessageHandler;
import org.aspectj.ajde.ui.swing.ErrorDialog;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserMessageHandler
implements IUIBuildMessageHandler {
    private List<IMessage.Kind> ignoring = new ArrayList<IMessage.Kind>();
    private List<IMessage> messages = new ArrayList<IMessage>();

    public BrowserMessageHandler() {
        this.ignore(IMessage.INFO);
        this.ignore(IMessage.WEAVEINFO);
    }

    @Override
    public boolean handleMessage(IMessage message) throws AbortException {
        IMessage.Kind messageKind = message.getKind();
        if (this.isIgnoring(messageKind)) {
            return true;
        }
        if (messageKind.equals(IMessage.ABORT) || message.getThrown() != null) {
            String stack = this.getStackTraceAsString(message.getThrown());
            ErrorDialog errorDialog = new ErrorDialog(Ajde.getDefault().getRootFrame(), "AJDE Error", message.getThrown(), message.getMessage(), stack);
            errorDialog.setVisible(true);
            return true;
        }
        this.messages.add(message);
        return true;
    }

    @Override
    public void dontIgnore(IMessage.Kind kind) {
        if (null != kind) {
            this.ignoring.remove(kind);
        }
    }

    @Override
    public boolean isIgnoring(IMessage.Kind kind) {
        return null != kind && this.ignoring.contains(kind);
    }

    @Override
    public void ignore(IMessage.Kind kind) {
        if (null != kind && !this.ignoring.contains(kind)) {
            this.ignoring.add(kind);
        }
    }

    public List<IMessage> getMessages() {
        return this.messages;
    }

    private String getStackTraceAsString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        if (t != null) {
            t.printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.getBuffer().toString();
        }
        return "<no stack trace available>";
    }

    @Override
    public void reset() {
        this.messages.clear();
    }
}

