/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.javaoptions;

import java.util.Map;
import org.aspectj.ajde.core.JavaOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBuildOptions {
    private Map<String, String> javaBuildOptions = JavaOptions.getDefaultJavaOptions();

    public Map<String, String> getJavaBuildOptionsMap() {
        return this.javaBuildOptions;
    }

    public void setOption(String javaOption, String value) {
        this.javaBuildOptions.put(javaOption, value);
    }

    public void setComplianceLevel(String level) {
        if (JavaOptions.isValidJvmVersion(level)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.compliance", level);
        }
    }

    public void setSourceCompatibilityLevel(String level) {
        if (JavaOptions.isValidJvmVersion(level)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.source", level);
        }
    }

    public void setTargetLevel(String level) {
        if (JavaOptions.isValidJvmVersion(level)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", level);
        }
    }

    public void setWarnMethodWithConstructorName(String option) {
        if (JavaOptions.isIgnoreOrWarning(option)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", option);
        }
    }

    public void setWarnOverridingPackageDefaultMethod(String option) {
        if (JavaOptions.isIgnoreOrWarning(option)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", option);
        }
    }

    public void setWarnDeprecation(String option) {
        if (JavaOptions.isIgnoreOrWarning(option)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", option);
        }
    }

    public void setWarnHiddenCatchBlocks(String option) {
        if (JavaOptions.isIgnoreOrWarning(option)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", option);
        }
    }

    public void setWarnUnusedLocals(String option) {
        if (JavaOptions.isIgnoreOrWarning(option)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", option);
        }
    }

    public void setWarnUnusedParameters(String option) {
        if (JavaOptions.isIgnoreOrWarning(option)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", option);
        }
    }

    public void setWarnUnusedImports(String option) {
        if (JavaOptions.isIgnoreOrWarning(option)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.problem.unusedImport", option);
        }
    }

    public void setWarnSyntheticAccess(String option) {
        if (JavaOptions.isIgnoreOrWarning(option)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", option);
        }
    }

    public void setWarnAssertIdentifier(String option) {
        if (JavaOptions.isIgnoreOrWarning(option)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", option);
        }
    }

    public void setWarnNonNLS(String option) {
        if (JavaOptions.isIgnoreOrWarning(option)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", option);
        }
    }

    public void setDebugSource(String option) {
        if (JavaOptions.isGenerateOrNot(option)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", option);
        }
    }

    public void setDebugLines(String option) {
        if (JavaOptions.isGenerateOrNot(option)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", option);
        }
    }

    public void setDebugVariables(String option) {
        if (JavaOptions.isGenerateOrNot(option)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", option);
        }
    }

    public void setPreserveAllLocals(String value) {
        if (JavaOptions.isValidPreserveAllLocalsOption(value)) {
            this.javaBuildOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", value);
        }
    }

    public void setCharacterEncoding(String value) {
        this.javaBuildOptions.put("org.eclipse.jdt.core.encoding", value);
    }
}

