/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubySymbol;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyHashUtil {
    private RubyHashUtil() {
    }

    public static RubyHash convertMapToRubyHashWithSymbols(Ruby rubyRuntime, Map<String, Object> options) {
        RubyHash rubyHash = new RubyHash(rubyRuntime);
        Set<Map.Entry<String, Object>> optionsSet = options.entrySet();
        for (Map.Entry<String, Object> entry : optionsSet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            RubySymbol newSymbol = RubyUtils.toSymbol(rubyRuntime, key);
            IRubyObject iRubyValue = RubyHashUtil.toRubyObject(rubyRuntime, value);
            rubyHash.put((Object)newSymbol, (Object)iRubyValue);
        }
        return rubyHash;
    }

    public static Map<String, Object> convertRubyHashMapToMap(Map<RubySymbol, Object> rubyHashMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set<Map.Entry<RubySymbol, Object>> elements = rubyHashMap.entrySet();
        for (Map.Entry<RubySymbol, Object> element : elements) {
            map.put(RubyHashUtil.toJavaString(element), RubyHashUtil.toJavaObject(element.getValue()));
        }
        return map;
    }

    private static String toJavaString(Map.Entry<RubySymbol, Object> element) {
        return element.getKey().asJavaString();
    }

    private static Object toJavaObject(Object rubyObject) {
        if (rubyObject instanceof IRubyObject) {
            IRubyObject iRubyObject = (IRubyObject)rubyObject;
            return JavaEmbedUtils.rubyToJava((IRubyObject)iRubyObject);
        }
        return rubyObject;
    }

    private static IRubyObject toRubyObject(Ruby rubyRuntime, Object value) {
        String stringValue;
        if (value instanceof List) {
            return RubyHashUtil.toRubyArray(rubyRuntime, (List)value);
        }
        if (value instanceof String && (stringValue = (String)value).startsWith(":")) {
            return RubyUtils.toSymbol(rubyRuntime, stringValue.substring(1));
        }
        IRubyObject iRubyObject = JavaEmbedUtils.javaToRuby((Ruby)rubyRuntime, (Object)value);
        return iRubyObject;
    }

    private static IRubyObject toRubyArray(Ruby rubyRuntime, List<Object> values) {
        RubyArray rubyArray = RubyArray.newArray((Ruby)rubyRuntime, (int)values.size());
        for (Object value : values) {
            rubyArray.add((Object)RubyHashUtil.toRubyObject(rubyRuntime, value));
        }
        return rubyArray;
    }

    public static RubyHash toNoneSymbolsRubyHash(Ruby rubyRuntime, Map<String, Object> map) {
        RubyHash rubyHash = new RubyHash(rubyRuntime);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            rubyHash.put(RubyHashUtil.toJavaObject(entry.getKey()), RubyHashUtil.toJavaObject(entry.getValue()));
        }
        return rubyHash;
    }
}

