/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.java.html.BrwsrCtx;
import org.apidesign.html.context.spi.Contexts;
import org.apidesign.html.json.impl.FromJSON;
import org.apidesign.html.json.impl.PropertyBindingAccessor;
import org.apidesign.html.json.impl.RcvrJSON;
import org.apidesign.html.json.spi.FunctionBinding;
import org.apidesign.html.json.spi.JSONCall;
import org.apidesign.html.json.spi.PropertyBinding;
import org.apidesign.html.json.spi.Technology;
import org.apidesign.html.json.spi.Transfer;
import org.apidesign.html.json.spi.WSTransfer;

public final class JSON {
    private static final Map<Class, FromJSON<?>> froms;

    private JSON() {
    }

    static Technology<?> findTechnology(BrwsrCtx c) {
        Technology t = (Technology)Contexts.find((BrwsrCtx)c, Technology.class);
        return t == null ? EmptyTech.EMPTY : t;
    }

    static Transfer findTransfer(BrwsrCtx c) {
        Transfer t = (Transfer)Contexts.find((BrwsrCtx)c, Transfer.class);
        return t == null ? EmptyTech.EMPTY : t;
    }

    static WSTransfer<?> findWSTransfer(BrwsrCtx c) {
        WSTransfer t = (WSTransfer)Contexts.find((BrwsrCtx)c, WSTransfer.class);
        return t == null ? EmptyTech.EMPTY : t;
    }

    public static void runInBrowser(BrwsrCtx c, Runnable runnable) {
        JSON.findTechnology(c).runSafe(runnable);
    }

    public static void extract(BrwsrCtx c, Object value, String[] props, Object[] values) {
        Transfer t = JSON.findTransfer(c);
        t.extract(value, props, values);
    }

    private static Object getProperty(BrwsrCtx c, Object obj, String prop) {
        if (prop == null) {
            return obj;
        }
        String[] arr = new String[]{prop};
        Object[] val = new Object[]{null};
        JSON.extract(c, obj, arr, val);
        return val[0];
    }

    public static Object toJSON(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Enum) {
            value = value.toString();
        }
        if (value instanceof String) {
            return '\"' + ((String)value).replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t") + '\"';
        }
        return value.toString();
    }

    public static String toString(BrwsrCtx c, Object obj, String prop) {
        return (obj = JSON.getProperty(c, obj, prop)) instanceof String ? (String)obj : null;
    }

    public static Number toNumber(BrwsrCtx c, Object obj, String prop) {
        if (!((obj = JSON.getProperty(c, obj, prop)) instanceof Number)) {
            obj = Double.NaN;
        }
        return (Number)obj;
    }

    public static <M> M toModel(BrwsrCtx c, Class<M> aClass, Object data, Object object) {
        Technology<?> t = JSON.findTechnology(c);
        M o = t.toModel(aClass, data);
        return aClass.cast(o);
    }

    public static boolean isSame(int a, int b) {
        return a == b;
    }

    public static boolean isSame(double a, double b) {
        return a == b;
    }

    public static boolean isSame(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static int hashPlus(Object o, int h) {
        return o == null ? h : h ^ o.hashCode();
    }

    public static <T> T extractValue(Class<T> type, Object val) {
        if (Number.class.isAssignableFrom(type)) {
            val = JSON.numberValue(val);
        }
        if (Boolean.class == type) {
            val = JSON.boolValue(val);
        }
        return type.cast(val);
    }

    public static String stringValue(Object val) {
        return (String)val;
    }

    public static Number numberValue(Object val) {
        if (val instanceof String) {
            try {
                return Double.valueOf((String)val);
            }
            catch (NumberFormatException ex) {
                return Double.NaN;
            }
        }
        return (Number)val;
    }

    public static Character charValue(Object val) {
        return (Character)val;
    }

    public static Boolean boolValue(Object val) {
        if (val instanceof String) {
            return Boolean.parseBoolean((String)val);
        }
        return Boolean.TRUE.equals(val);
    }

    public static void loadJSON(BrwsrCtx c, RcvrJSON callback, String urlBefore, String urlAfter, String method, Object data) {
        JSONCall call = PropertyBindingAccessor.createCall(c, callback, urlBefore, urlAfter, method, data);
        Transfer t = JSON.findTransfer(c);
        t.loadJSON(call);
    }

    public static WS openWS(BrwsrCtx c, RcvrJSON r, String url, Object data) {
        WS ws = WSImpl.create(JSON.findWSTransfer(c), r);
        ws.send(c, url, data);
        return ws;
    }

    public static void register(FromJSON<?> from) {
        froms.put(from.factoryFor(), from);
    }

    public static boolean isModel(Class<?> clazz) {
        return JSON.findFrom(clazz) != null;
    }

    private static FromJSON<?> findFrom(Class<?> clazz) {
        for (int i = 0; i < 2; ++i) {
            FromJSON<?> from = froms.get(clazz);
            if (from != null) {
                return from;
            }
            JSON.initClass(clazz);
        }
        return null;
    }

    public static <Model> Model bindTo(Model model, BrwsrCtx c) {
        FromJSON<?> from = JSON.findFrom(model.getClass());
        if (from == null) {
            throw new IllegalArgumentException();
        }
        return (Model)from.cloneTo(model, c);
    }

    public static <T> T readStream(BrwsrCtx c, Class<T> modelClazz, InputStream data) throws IOException {
        Transfer tr = JSON.findTransfer(c);
        return JSON.read(c, modelClazz, tr.toJSON(data));
    }

    public static <T> T read(BrwsrCtx c, Class<T> modelClazz, Object data) {
        if (data == null) {
            return null;
        }
        if (modelClazz == String.class) {
            return modelClazz.cast(data.toString());
        }
        for (int i = 0; i < 2; ++i) {
            FromJSON<?> from = froms.get(modelClazz);
            if (from != null) {
                return modelClazz.cast(from.read(c, data));
            }
            JSON.initClass(modelClazz);
        }
        throw new NullPointerException();
    }

    static void initClass(Class<?> modelClazz) {
        try {
            ClassLoader l;
            try {
                l = modelClazz.getClassLoader();
            }
            catch (SecurityException ex) {
                l = null;
            }
            if (l != null) {
                Class.forName(modelClazz.getName(), true, l);
            }
            modelClazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        HashMap m = new HashMap();
        froms = m;
    }

    private static final class EmptyTech
    implements Technology<Object>,
    Transfer,
    WSTransfer<Void> {
        private static final EmptyTech EMPTY = new EmptyTech();

        private EmptyTech() {
        }

        @Override
        public Object wrapModel(Object model) {
            return model;
        }

        @Override
        public void valueHasMutated(Object data, String propertyName) {
        }

        @Override
        public void bind(PropertyBinding b, Object model, Object data) {
        }

        @Override
        public void expose(FunctionBinding fb, Object model, Object d) {
        }

        @Override
        public void applyBindings(Object data) {
        }

        @Override
        public Object wrapArray(Object[] arr) {
            return arr;
        }

        @Override
        public void extract(Object obj, String[] props, Object[] values) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = null;
            }
        }

        @Override
        public void loadJSON(JSONCall call) {
            call.notifyError(new UnsupportedOperationException());
        }

        @Override
        public <M> M toModel(Class<M> modelClass, Object data) {
            return modelClass.cast(data);
        }

        @Override
        public Object toJSON(InputStream is) throws IOException {
            throw new IOException("Not supported");
        }

        @Override
        public synchronized void runSafe(Runnable r) {
            r.run();
        }

        @Override
        public Void open(String url, JSONCall onReply) {
            onReply.notifyError(new UnsupportedOperationException("WebSockets not supported!"));
            return null;
        }

        @Override
        public void send(Void socket, JSONCall data) {
        }

        @Override
        public void close(Void socket) {
        }
    }

    private static final class WSImpl<Socket>
    extends WS {
        private final WSTransfer<Socket> trans;
        private final RcvrJSON rcvr;
        private Socket socket;
        private String prevURL;

        private WSImpl(WSTransfer<Socket> trans, RcvrJSON rcvr) {
            this.trans = trans;
            this.rcvr = rcvr;
        }

        static <Socket> WS create(WSTransfer<Socket> t, RcvrJSON r) {
            return new WSImpl<Socket>(t, r);
        }

        @Override
        public void send(BrwsrCtx ctx, String url, Object data) {
            Socket s = this.socket;
            if (s == null) {
                if (data != null) {
                    throw new IllegalStateException("WebSocket is not opened yet. Call with null data, was: " + data);
                }
                JSONCall call = PropertyBindingAccessor.createCall(ctx, this.rcvr, url, null, "WebSocket", null);
                this.socket = this.trans.open(url, call);
                this.prevURL = url;
                return;
            }
            if (data == null) {
                this.trans.close(s);
                this.socket = null;
                return;
            }
            if (!this.prevURL.equals(url)) {
                throw new IllegalStateException("Can't call to different URL " + url + " was: " + this.prevURL + "!" + " Close the socket by calling it will null data first!");
            }
            JSONCall call = PropertyBindingAccessor.createCall(ctx, this.rcvr, this.prevURL, null, "WebSocket", data);
            this.trans.send(s, call);
        }
    }

    public static abstract class WS {
        private WS() {
        }

        public abstract void send(BrwsrCtx var1, String var2, Object var3);
    }
}

