/**
 * HTML via Java(tm) Language Bindings
 * Copyright (C) 2013 Jaroslav Tulach <jaroslav.tulach@apidesign.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. apidesign.org
 * designates this particular file as subject to the
 * "Classpath" exception as provided by apidesign.org
 * in the License file that accompanied this code.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://wiki.apidesign.org/wiki/GPLwithClassPathException
 */
package net.java.html.json;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/** Defines a model class named {@link #className()} which contains
 * properties defined via {@link #properties()}. This class can have methods 
 * annotated by {@link ComputedProperty} which define derived
 * properties in the model class.
 * <p>
 * The {@link #className() generated class}'s <code>toString</code>
 * converts the state of the object into 
 * <a href="http://en.wikipedia.org/wiki/JSON">JSON</a> format. 
 * <p>
 * An example where one defines class <code>Person</code> with three 
 * properties (<code>firstName</code>, <code>lastName</code> and
 * <code>fullName</code>) follows:
 * <pre>
 * {@link Model @Model}(className="Person", properties={
 *   {@link Property @Property}(name = "firstName", type=String.class),
 *   {@link Property @Property}(name = "lastName", type=String.class)
 * })
 * static class PersonImpl {
 *   {@link ComputedProperty @ComputedProperty}
 *   static String fullName(String firstName, String lastName) {
 *     return firstName + " " + lastName;
 *   }
 * }
 * </pre>
 *
 * @author Jaroslav Tulach <jtulach@netbeans.org>
 */
@Retention(RetentionPolicy.SOURCE)
@Target(ElementType.TYPE)
public @interface Model {
    /** Name of the model class */
    String className();
    /** List of properties in the model.
     */
    Property[] properties();
}
