/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.samples;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import org.apfloat.samples.BackgroundOperation;
import org.apfloat.samples.Operation;
import org.apfloat.samples.OperationExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteOperationExecutor
implements OperationExecutor {
    private static final int BUFFER_SIZE = 8192;
    private String host;
    private int port;

    public RemoteOperationExecutor(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public <T> T execute(Operation<T> operation) {
        Object result;
        SocketChannel channel = null;
        try {
            Object obj;
            channel = SocketChannel.open(new InetSocketAddress(this.host, this.port));
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(Channels.newOutputStream(channel), 8192));
            out.writeObject(operation);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(Channels.newInputStream(channel));
            result = obj = in.readObject();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        finally {
            try {
                channel.socket().shutdownOutput();
                channel.close();
            }
            catch (Exception e) {}
        }
        return (T)result;
    }

    @Override
    public <T> BackgroundOperation<T> executeBackground(final Operation<T> operation) {
        return new BackgroundOperation(new Operation<T>(){

            @Override
            public T execute() {
                return RemoteOperationExecutor.this.execute(operation);
            }
        });
    }

    @Override
    public int getWeight() {
        return 1;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

