/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.samples;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.samples.ApfloatHolder;
import org.apfloat.samples.BackgroundOperation;
import org.apfloat.samples.Operation;
import org.apfloat.samples.Pi;
import org.apfloat.samples.PiParallel;
import org.apfloat.samples.RemoteOperationExecutor;

public class PiDistributed
extends PiParallel {
    private static final int MIN_WEIGHT = 1;
    private static final int MAX_WEIGHT = 1000;
    private static final boolean DEBUG = false;

    PiDistributed() {
    }

    public static void main(String[] args) throws IOException, ApfloatRuntimeException {
        Operation<Apfloat> operation;
        if (args.length < 1) {
            System.err.println("USAGE: PiDistributed digits [method] [radix]");
            System.err.println("    radix must be 2...36");
            return;
        }
        long precision = PiDistributed.getPrecision(args[0]);
        int method = args.length > 1 ? PiDistributed.getInt(args[1], "method", 0, 1) : 0;
        int radix = args.length > 2 ? PiDistributed.getRadix(args[2]) : ApfloatContext.getContext().getDefaultRadix();
        switch (method) {
            case 0: {
                operation = new DistributedChudnovskyPiCalculator(precision, radix);
                break;
            }
            default: {
                operation = new DistributedRamanujanPiCalculator(precision, radix);
            }
        }
        PiDistributed.setOut(new PrintWriter(System.out, true));
        PiDistributed.setErr(new PrintWriter(System.err, true));
        PiDistributed.run(precision, radix, operation);
    }

    private static String formatArray(Object[] array) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ ");
        for (int i = 0; i < array.length; ++i) {
            buffer.append(i == 0 ? "" : ", ");
            buffer.append(array[i]);
        }
        buffer.append(" }");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Node
    extends RemoteOperationExecutor
    implements Comparable<Node> {
        private int weight;
        private int numberOfProcessors;

        public Node(String host, int port, int weight) {
            this(host, port, weight, 1);
        }

        public Node(String host, int port, int weight, int numberOfProcessors) {
            super(host, port);
            this.weight = weight;
            this.numberOfProcessors = numberOfProcessors;
        }

        @Override
        public <T> T execute(Operation<T> operation) {
            return super.execute(new PiParallel.ThreadLimitedOperation<T>(operation, this.numberOfProcessors));
        }

        @Override
        public <T> BackgroundOperation<T> executeBackground(Operation<T> operation) {
            return super.executeBackground(new PiParallel.ThreadLimitedOperation<T>(operation, this.numberOfProcessors));
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        public void setNumberOfProcessors(int numberOfProcessors) {
            this.numberOfProcessors = numberOfProcessors;
        }

        public int getNumberOfProcessors() {
            return this.numberOfProcessors;
        }

        @Override
        public int compareTo(Node that) {
            int weightDifference = this.weight - that.weight;
            return weightDifference != 0 ? weightDifference : this.hashCode() - that.hashCode();
        }

        public String toString() {
            return this.weight + "/" + this.numberOfProcessors;
        }
    }

    public static class DistributedRamanujanPiCalculator
    extends PiParallel.ParallelRamanujanPiCalculator {
        private DistributedBinarySplittingPiCalculator calculator;
        private long precision;
        private int radix;

        public DistributedRamanujanPiCalculator(long precision, int radix) throws ApfloatRuntimeException {
            this(new DistributedBinarySplittingPiCalculator(new Pi.RamanujanBinarySplittingSeries(precision, radix)), precision, radix);
        }

        private DistributedRamanujanPiCalculator(DistributedBinarySplittingPiCalculator calculator, long precision, int radix) throws ApfloatRuntimeException {
            super(calculator, precision, radix);
            this.calculator = calculator;
            this.precision = precision;
            this.radix = radix;
        }

        public Apfloat execute() {
            Pi.err.println("Using the Ramanujan binary splitting algorithm");
            Node[] nodes = this.calculator.getNodes();
            if (nodes.length > 1) {
                Pi.err.println("Using up to " + nodes.length + " parallel operations for calculation");
            }
            final Apfloat f = new Apfloat(8L, this.precision, this.radix);
            final ApfloatHolder T = new ApfloatHolder();
            final ApfloatHolder Q = new ApfloatHolder();
            final ApfloatHolder F = new ApfloatHolder(f);
            long terms = (long)((double)this.precision * Math.log(this.radix) / 18.38047940053836);
            long time = System.currentTimeMillis();
            this.calculator.r(0L, terms + 1L, T, Q, null, F, nodes);
            time = System.currentTimeMillis() - time;
            Pi.err.println("Series terms calculation complete, elapsed time " + (double)time / 1000.0 + " seconds");
            Pi.err.printf("Final value ", new Object[0]);
            nodes = this.calculator.recombineNodes(nodes, 1);
            time = System.currentTimeMillis();
            Apfloat pi = nodes[nodes.length - 1].execute(new Operation<Apfloat>(){

                @Override
                public Apfloat execute() {
                    Apfloat t = T.getApfloat();
                    Apfloat q = Q.getApfloat();
                    Apfloat factor = F.getApfloat();
                    if (factor == f) {
                        factor = ApfloatMath.inverseRoot((Apfloat)f, (long)2L);
                    }
                    return ApfloatMath.inverseRoot((Apfloat)t, (long)1L).multiply(factor).multiply(new Apfloat(9801L, Long.MAX_VALUE, DistributedRamanujanPiCalculator.this.radix)).multiply(q);
                }
            });
            time = System.currentTimeMillis() - time;
            Pi.err.println("took " + (double)time / 1000.0 + " seconds");
            return pi;
        }
    }

    public static class DistributedChudnovskyPiCalculator
    extends PiParallel.ParallelChudnovskyPiCalculator {
        private DistributedBinarySplittingPiCalculator calculator;
        private long precision;
        private int radix;

        public DistributedChudnovskyPiCalculator(long precision, int radix) throws ApfloatRuntimeException {
            this(new DistributedBinarySplittingPiCalculator(new Pi.ChudnovskyBinarySplittingSeries(precision, radix)), precision, radix);
        }

        private DistributedChudnovskyPiCalculator(DistributedBinarySplittingPiCalculator calculator, long precision, int radix) throws ApfloatRuntimeException {
            super(calculator, precision, radix);
            this.calculator = calculator;
            this.precision = precision;
            this.radix = radix;
        }

        public Apfloat execute() {
            Pi.err.println("Using the Chudnovsky brothers' binary splitting algorithm");
            Node[] nodes = this.calculator.getNodes();
            if (nodes.length > 1) {
                Pi.err.println("Using up to " + nodes.length + " parallel operations for calculation");
            }
            final Apfloat f = new Apfloat(1823176476672000L, this.precision, this.radix);
            final ApfloatHolder T = new ApfloatHolder();
            final ApfloatHolder Q = new ApfloatHolder();
            final ApfloatHolder F = new ApfloatHolder(f);
            long terms = (long)((double)this.precision * Math.log(this.radix) / 32.65445004177);
            long time = System.currentTimeMillis();
            this.calculator.r(0L, terms + 1L, T, Q, null, F, nodes);
            time = System.currentTimeMillis() - time;
            Pi.err.println("Series terms calculation complete, elapsed time " + (double)time / 1000.0 + " seconds");
            Pi.err.printf("Final value ", new Object[0]);
            nodes = this.calculator.recombineNodes(nodes, 1);
            time = System.currentTimeMillis();
            Apfloat pi = nodes[nodes.length - 1].execute(new Operation<Apfloat>(){

                @Override
                public Apfloat execute() {
                    Apfloat t = T.getApfloat();
                    Apfloat q = Q.getApfloat();
                    Apfloat factor = F.getApfloat();
                    if (factor == f) {
                        factor = ApfloatMath.inverseRoot((Apfloat)f, (long)2L);
                    }
                    return ApfloatMath.inverseRoot((Apfloat)factor.multiply(t), (long)1L).multiply(q);
                }
            });
            time = System.currentTimeMillis() - time;
            Pi.err.println("took " + (double)time / 1000.0 + " seconds");
            return pi;
        }
    }

    protected static class DistributedBinarySplittingPiCalculator
    extends PiParallel.ParallelBinarySplittingPiCalculator {
        public DistributedBinarySplittingPiCalculator(Pi.BinarySplittingSeries series) {
            super(series);
        }

        public void r(final long n1, final long n2, final ApfloatHolder T, final ApfloatHolder Q, final ApfloatHolder P, final ApfloatHolder F, Node[] nodes) throws ApfloatRuntimeException {
            if (nodes.length == 1) {
                ApfloatHolder[] TQP = nodes[0].execute(new Operation<ApfloatHolder[]>(){

                    @Override
                    public ApfloatHolder[] execute() {
                        DistributedBinarySplittingPiCalculator.this.r(n1, n2, T, Q, P, null);
                        return new ApfloatHolder[]{T, Q, P};
                    }
                });
                T.setApfloat(TQP[0].getApfloat());
                Q.setApfloat(TQP[1].getApfloat());
                if (P != null) {
                    P.setApfloat(TQP[2].getApfloat());
                }
            } else {
                Object[] objs = this.splitNodes(nodes);
                final Node[] nodes1 = (Node[])objs[0];
                Node[] nodes2 = (Node[])objs[2];
                long weight1 = (Long)objs[1];
                long weight2 = (Long)objs[3];
                final long nMiddle = n1 + (n2 - n1) * weight1 / (weight1 + weight2);
                final ApfloatHolder LT = new ApfloatHolder();
                final ApfloatHolder LQ = new ApfloatHolder();
                final ApfloatHolder LP = new ApfloatHolder();
                BackgroundOperation<Object> operation = new BackgroundOperation<Object>(new Operation<Object>(){

                    @Override
                    public Object execute() {
                        DistributedBinarySplittingPiCalculator.this.r(n1, nMiddle, LT, LQ, LP, null, nodes1);
                        return null;
                    }
                });
                this.r(nMiddle, n2, T, Q, P, null, nodes2);
                operation.getResult();
                assert (P == null || F == null);
                int numberNeeded = (P != null || F != null ? 1 : 0) + 3;
                nodes = this.recombineNodes(nodes, numberNeeded);
                Operation<Apfloat> sqrtOperation = new Operation<Apfloat>(){

                    @Override
                    public Apfloat execute() {
                        return ApfloatMath.inverseRoot((Apfloat)F.getApfloat(), (long)2L);
                    }
                };
                final Operation<Apfloat> T1operation = new Operation<Apfloat>(){

                    @Override
                    public Apfloat execute() {
                        return Q.getApfloat().multiply(LT.getApfloat());
                    }
                };
                final Operation<Apfloat> T2operation = new Operation<Apfloat>(){

                    @Override
                    public Apfloat execute() {
                        return LP.getApfloat().multiply(T.getApfloat());
                    }
                };
                Operation<Apfloat> Toperation = new Operation<Apfloat>(){

                    @Override
                    public Apfloat execute() {
                        return ((Apfloat)T1operation.execute()).add((Apfloat)T2operation.execute());
                    }
                };
                final Operation<Apfloat> Qoperation = new Operation<Apfloat>(){

                    @Override
                    public Apfloat execute() {
                        return LQ.getApfloat().multiply(Q.getApfloat());
                    }
                };
                final Operation<Apfloat> Poperation = new Operation<Apfloat>(){

                    @Override
                    public Apfloat execute() {
                        return LP.getApfloat().multiply(P.getApfloat());
                    }
                };
                Operation<Apfloat[]> QPoperation = new Operation<Apfloat[]>(){

                    @Override
                    public Apfloat[] execute() {
                        return new Apfloat[]{(Apfloat)Qoperation.execute(), P == null ? null : (Apfloat)Poperation.execute()};
                    }
                };
                int availableNodes = nodes.length;
                BackgroundOperation<Apfloat> sqrtBackgroundOperation = null;
                BackgroundOperation<Apfloat> operation3 = null;
                if (F != null && availableNodes > 1) {
                    sqrtBackgroundOperation = nodes[availableNodes - 1].executeBackground(sqrtOperation);
                    --availableNodes;
                }
                Apfloat t = null;
                Apfloat q = null;
                Apfloat p = null;
                switch (availableNodes) {
                    case 1: {
                        t = nodes[0].execute(Toperation);
                        q = nodes[0].execute(Qoperation);
                        if (P == null) break;
                        p = nodes[0].execute(Poperation);
                        break;
                    }
                    case 2: {
                        BackgroundOperation<Apfloat> operation1 = nodes[1].executeBackground(T1operation);
                        Apfloat tmp1 = nodes[0].execute(T2operation);
                        Apfloat tmp2 = operation1.getResult();
                        operation1 = nodes[1].executeBackground(Qoperation);
                        t = this.executeAdd(nodes[0], tmp1, tmp2);
                        if (P != null) {
                            p = nodes[0].execute(Poperation);
                        }
                        q = operation1.getResult();
                        break;
                    }
                    case 3: {
                        BackgroundOperation<Apfloat[]> operation1a = nodes[2].executeBackground(QPoperation);
                        BackgroundOperation<Apfloat> operation2 = nodes[1].executeBackground(T1operation);
                        Apfloat tmp1 = nodes[0].execute(T2operation);
                        Apfloat tmp2 = operation2.getResult();
                        t = this.executeAdd(nodes[1], tmp1, tmp2);
                        Apfloat[] QP = operation1a.getResult();
                        q = QP[0];
                        if (P == null) break;
                        p = QP[1];
                        break;
                    }
                    default: {
                        BackgroundOperation<Apfloat> operation1 = nodes[availableNodes - 1].executeBackground(T1operation);
                        BackgroundOperation<Apfloat> operation2 = nodes[availableNodes - 3].executeBackground(Qoperation);
                        if (P != null) {
                            operation3 = nodes[availableNodes - 4].executeBackground(Poperation);
                        }
                        Apfloat tmp1 = nodes[availableNodes - 2].execute(T2operation);
                        Apfloat tmp2 = operation1.getResult();
                        t = this.executeAdd(nodes[availableNodes - 1], tmp1, tmp2);
                        q = operation2.getResult();
                        if (P == null) break;
                        p = operation3.getResult();
                        break;
                    }
                }
                T.setApfloat(t);
                Q.setApfloat(q);
                if (P != null) {
                    P.setApfloat(p);
                }
                if (sqrtBackgroundOperation != null) {
                    F.setApfloat(sqrtBackgroundOperation.getResult());
                }
            }
        }

        public Node[] getNodes() {
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle("cluster");
            }
            catch (MissingResourceException mre) {
                System.err.println("ResourceBundle \"cluster\" not found");
                System.exit(1);
            }
            Object[] nodes = null;
            ArrayList<Node> list = new ArrayList<Node>();
            long totalWeight = 0L;
            int weightedNodes = 0;
            Enumeration<String> keys = resourceBundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!key.startsWith("server")) continue;
                int weight = -1;
                try {
                    String weightString = resourceBundle.getString("weight" + key.substring(6));
                    try {
                        weight = Integer.parseInt(weightString);
                        if (weight < 1 || weight > 1000) {
                            throw new NumberFormatException(weightString);
                        }
                        ++weightedNodes;
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Invalid weight: " + nfe.getMessage());
                        System.exit(1);
                    }
                    totalWeight += (long)weight;
                }
                catch (MissingResourceException mre) {
                    // empty catch block
                }
                String server = resourceBundle.getString(key);
                int index = server.indexOf(58);
                if (index < 0) {
                    System.err.println("No port specified for server: " + server);
                    System.exit(1);
                }
                String host = server.substring(0, index);
                String portString = server.substring(index + 1);
                int port = 0;
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Invalid port for host " + host + ": " + portString);
                    System.exit(1);
                }
                list.add(new Node(host, port, weight));
            }
            if (list.size() == 0) {
                System.err.println("No nodes for cluster specified");
                System.exit(1);
            }
            nodes = list.toArray(new Node[list.size()]);
            int averageWeight = weightedNodes == 0 ? 1 : (int)(totalWeight / (long)weightedNodes);
            for (Object node : nodes) {
                if (((Node)node).getWeight() != -1) continue;
                ((Node)node).setWeight(averageWeight);
            }
            Arrays.sort(nodes);
            for (Object node : nodes) {
                int numberOfProcessors = ((Node)node).execute(new Operation<Integer>(){

                    @Override
                    public Integer execute() {
                        return ApfloatContext.getGlobalContext().getNumberOfProcessors();
                    }
                });
                ((Node)node).setNumberOfProcessors(numberOfProcessors);
            }
            return nodes;
        }

        public Node[] recombineNodes(Node[] nodes, int numberNeeded) {
            if (numberNeeded <= nodes.length) {
                return nodes;
            }
            TreeSet allNodes = new TreeSet();
            TreeSet<Node> splittableNodes = new TreeSet<Node>();
            for (Node node : nodes) {
                (node.getNumberOfProcessors() > 1 ? splittableNodes : allNodes).add(node);
            }
            while (splittableNodes.size() > 0 && allNodes.size() + splittableNodes.size() < numberNeeded) {
                Node node = (Node)splittableNodes.last();
                int numberOfProcessors = node.getNumberOfProcessors();
                int numberOfProcessors1 = numberOfProcessors / 2;
                int numberOfProcessors2 = (numberOfProcessors + 1) / 2;
                Node node1 = new Node(node.getHost(), node.getPort(), node.getWeight() * numberOfProcessors1 / numberOfProcessors, numberOfProcessors1);
                Node node2 = new Node(node.getHost(), node.getPort(), node.getWeight() * numberOfProcessors2 / numberOfProcessors, numberOfProcessors2);
                splittableNodes.remove(node);
                (node1.getNumberOfProcessors() > 1 ? splittableNodes : allNodes).add(node1);
                (node2.getNumberOfProcessors() > 1 ? splittableNodes : allNodes).add(node2);
            }
            allNodes.addAll(splittableNodes);
            Node[] newNodes = allNodes.toArray(new Node[allNodes.size()]);
            return newNodes;
        }

        private Object[] splitNodes(Node[] nodes) {
            LinkedList<Node> list1 = new LinkedList<Node>();
            LinkedList<Node> list2 = new LinkedList<Node>();
            long weight1 = 0L;
            long weight2 = 0L;
            int i = nodes.length;
            while (--i >= 0) {
                if (weight1 < weight2) {
                    list1.add(0, nodes[i]);
                    weight1 += (long)nodes[i].getWeight();
                    continue;
                }
                list2.add(0, nodes[i]);
                weight2 += (long)nodes[i].getWeight();
            }
            return new Object[]{list1.toArray(new Node[list1.size()]), weight1, list2.toArray(new Node[list2.size()]), weight2};
        }

        private Apfloat executeAdd(Node node, final Apfloat x, final Apfloat y) {
            return node.execute(new Operation<Apfloat>(){

                @Override
                public Apfloat execute() {
                    return x.add(y);
                }
            });
        }
    }
}

