/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.calc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apfloat.calc.CalculatorImpl;
import org.apfloat.calc.CalculatorParserConstants;
import org.apfloat.calc.CalculatorParserTokenManager;
import org.apfloat.calc.ParseException;
import org.apfloat.calc.SimpleCharStream;
import org.apfloat.calc.Token;

public class CalculatorParser
implements CalculatorParserConstants {
    private PrintWriter out;
    private CalculatorImpl calculatorImpl;
    public CalculatorParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();

    public CalculatorParser(InputStream in, OutputStream out, CalculatorImpl calculatorImpl) {
        this(in);
        this.out = new PrintWriter((Writer)new OutputStreamWriter(out), true);
        this.calculatorImpl = calculatorImpl;
    }

    public CalculatorParser(Reader in, Writer out, CalculatorImpl calculatorImpl) {
        this(in);
        this.out = new PrintWriter(out, true);
        this.calculatorImpl = calculatorImpl;
    }

    public CalculatorParser(Reader in, PrintWriter out, CalculatorImpl calculatorImpl) {
        this(in);
        this.out = out;
        this.calculatorImpl = calculatorImpl;
    }

    public final boolean parseOneLine() throws ParseException {
        Number a;
        if (this.jj_2_1(2)) {
            a = this.expression();
            this.out.println(this.calculatorImpl.format(a));
        }
        while (this.jj_2_2(2)) {
            this.jj_consume_token(9);
            a = this.expression();
            this.out.println(this.calculatorImpl.format(a));
        }
        if (this.jj_2_3(2)) {
            this.jj_consume_token(9);
        }
        if (this.jj_2_4(2)) {
            this.jj_consume_token(10);
            return true;
        }
        if (this.jj_2_5(2)) {
            this.jj_consume_token(0);
            return false;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Number expression() throws ParseException {
        Number a;
        if (this.jj_2_6(2)) {
            a = this.assignmentExpression();
        } else if (this.jj_2_7(2)) {
            a = this.additiveExpression();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return a;
    }

    public final Number assignmentExpression() throws ParseException {
        String v = this.variable();
        if (this.jj_2_8(2)) {
            this.jj_consume_token(11);
            Number a = this.additiveExpression();
            this.calculatorImpl.setVariable(v, a);
        } else if (this.jj_2_9(2)) {
            this.jj_consume_token(12);
            Number a = this.additiveExpression();
            this.calculatorImpl.setVariable(v, this.calculatorImpl.add(this.calculatorImpl.getVariable(v), a));
        } else if (this.jj_2_10(2)) {
            this.jj_consume_token(13);
            Number a = this.additiveExpression();
            this.calculatorImpl.setVariable(v, this.calculatorImpl.subtract(this.calculatorImpl.getVariable(v), a));
        } else if (this.jj_2_11(2)) {
            this.jj_consume_token(14);
            Number a = this.additiveExpression();
            this.calculatorImpl.setVariable(v, this.calculatorImpl.multiply(this.calculatorImpl.getVariable(v), a));
        } else if (this.jj_2_12(2)) {
            this.jj_consume_token(15);
            Number a = this.additiveExpression();
            this.calculatorImpl.setVariable(v, this.calculatorImpl.divide(this.calculatorImpl.getVariable(v), a));
        } else if (this.jj_2_13(2)) {
            this.jj_consume_token(16);
            Number a = this.additiveExpression();
            this.calculatorImpl.setVariable(v, this.calculatorImpl.mod(this.calculatorImpl.getVariable(v), a));
        } else if (this.jj_2_14(2)) {
            this.jj_consume_token(17);
            Number a = this.additiveExpression();
            this.calculatorImpl.setVariable(v, this.calculatorImpl.pow(this.calculatorImpl.getVariable(v), a));
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return this.calculatorImpl.getVariable(v);
    }

    public final Number additiveExpression() throws ParseException {
        Number a = this.multiplicativeExpression();
        while (this.jj_2_15(2)) {
            Number b;
            if (this.jj_2_16(2)) {
                this.jj_consume_token(18);
                b = this.multiplicativeExpression();
                a = this.calculatorImpl.add(a, b);
                continue;
            }
            if (this.jj_2_17(2)) {
                this.jj_consume_token(19);
                b = this.multiplicativeExpression();
                a = this.calculatorImpl.subtract(a, b);
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return a;
    }

    public final Number multiplicativeExpression() throws ParseException {
        Number a = this.unaryExpression();
        while (this.jj_2_18(2)) {
            Number b;
            if (this.jj_2_19(2)) {
                this.jj_consume_token(20);
                b = this.unaryExpression();
                a = this.calculatorImpl.multiply(a, b);
                continue;
            }
            if (this.jj_2_20(2)) {
                this.jj_consume_token(21);
                b = this.unaryExpression();
                a = this.calculatorImpl.divide(a, b);
                continue;
            }
            if (this.jj_2_21(2)) {
                this.jj_consume_token(22);
                b = this.unaryExpression();
                a = this.calculatorImpl.mod(a, b);
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return a;
    }

    public final Number unaryExpression() throws ParseException {
        if (this.jj_2_22(2)) {
            this.jj_consume_token(19);
            Number a = this.unaryExpression();
            return this.calculatorImpl.negate(a);
        }
        if (this.jj_2_23(2)) {
            this.jj_consume_token(18);
            Number a = this.unaryExpression();
            return a;
        }
        if (this.jj_2_24(2)) {
            Number a = this.powerExpression();
            return a;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Number powerExpression() throws ParseException {
        Number a = this.element();
        if (this.jj_2_25(2)) {
            this.jj_consume_token(23);
            Number b = this.unaryExpression();
            a = this.calculatorImpl.pow(a, b);
        }
        return a;
    }

    public final Number element() throws ParseException {
        if (this.jj_2_26(2)) {
            Number a = this.constant();
            return a;
        }
        if (this.jj_2_27(2)) {
            Number a = this.function();
            return a;
        }
        if (this.jj_2_28(2)) {
            String v = this.variable();
            return this.calculatorImpl.getVariable(v);
        }
        if (this.jj_2_29(2)) {
            this.jj_consume_token(24);
            Number a = this.expression();
            this.jj_consume_token(25);
            return a;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String variable() throws ParseException {
        String v = this.identifier();
        return v;
    }

    public final Number function() throws ParseException {
        String v = this.identifier();
        this.jj_consume_token(24);
        List<Number> l = this.argumentList();
        this.jj_consume_token(25);
        return this.calculatorImpl.function(v, l);
    }

    public final List<Number> argumentList() throws ParseException {
        ArrayList<Number> list = new ArrayList<Number>();
        if (this.jj_2_31(2)) {
            Number a = this.expression();
            list.add(a);
            while (this.jj_2_30(2)) {
                this.jj_consume_token(26);
                a = this.expression();
                list.add(a);
            }
        }
        return list;
    }

    public final String identifier() throws ParseException {
        Token t = this.jj_consume_token(7);
        return t.toString();
    }

    public final Number constant() throws ParseException {
        if (this.jj_2_32(2)) {
            Token t = this.jj_consume_token(3);
            return this.calculatorImpl.parseInteger(t.toString());
        }
        if (this.jj_2_33(2)) {
            Token t = this.jj_consume_token(4);
            return this.calculatorImpl.parseDecimal(t.toString());
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_1();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_2();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_3();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_4();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_5();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_6();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_7();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_8();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_9();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_10();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_11();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_12();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_13();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_14();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_15();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_16();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_17();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_18();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_19();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_20();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_21();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_22();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_23();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_24();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_25();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_26();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_27();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_28();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_29();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_30();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_31();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_32();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_33();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_3_4() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3_29() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_5();
    }

    private boolean jj_3_3() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3_28() {
        return this.jj_3R_13();
    }

    private boolean jj_3_27() {
        return this.jj_3R_12();
    }

    private boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_26()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_27()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_28()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_29()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_26() {
        return this.jj_3R_11();
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_5();
    }

    private boolean jj_3_1() {
        return this.jj_3R_5();
    }

    private boolean jj_3_25() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3R_10() {
        if (this.jj_3R_14()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_25()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_24() {
        return this.jj_3R_10();
    }

    private boolean jj_3_23() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3R_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_22()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_23()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_24()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_22() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3_21() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3_20() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_20()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_21()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_19() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3R_8() {
        Token xsp;
        if (this.jj_3R_9()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_18());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_33() {
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_33()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_32() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3_17() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_8();
    }

    private boolean jj_3_16() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_8();
    }

    private boolean jj_3_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_16()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_17()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_15() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_7() {
        Token xsp;
        if (this.jj_3R_8()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_15());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_30() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_3R_5();
    }

    private boolean jj_3_14() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        return this.jj_3R_7();
    }

    private boolean jj_3_31() {
        Token xsp;
        if (this.jj_3R_5()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_30());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_13() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_7();
    }

    private boolean jj_3_12() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_3R_7();
    }

    private boolean jj_3_11() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_7();
    }

    private boolean jj_3_10() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_7();
    }

    private boolean jj_3_9() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_3R_7();
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_7();
    }

    private boolean jj_3R_6() {
        if (this.jj_3R_13()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_9()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_10()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_11()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_12()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_13()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_14()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_12() {
        if (this.jj_3R_15()) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3_7() {
        return this.jj_3R_7();
    }

    private boolean jj_3_6() {
        return this.jj_3R_6();
    }

    private boolean jj_3R_13() {
        return this.jj_3R_15();
    }

    private boolean jj_3R_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_7()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        return this.jj_scan_token(0);
    }

    public CalculatorParser(InputStream stream) {
        this(stream, null);
    }

    public CalculatorParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new CalculatorParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public CalculatorParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new CalculatorParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public CalculatorParser(CalculatorParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(CalculatorParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

