/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.aparapi;

import org.apfloat.ApfloatContext;
import org.apfloat.aparapi.LongAparapiColumnSixStepFNTStrategy;
import org.apfloat.aparapi.LongAparapiColumnTwoPassFNTStrategy;
import org.apfloat.aparapi.LongAparapiFactor3NTTStrategy;
import org.apfloat.aparapi.LongAparapiNTTStrategy;
import org.apfloat.aparapi.LongAparapiSixStepFNTStrategy;
import org.apfloat.aparapi.LongAparapiTwoPassFNTStrategy;
import org.apfloat.internal.LongNTTBuilder;
import org.apfloat.spi.BuilderFactory;
import org.apfloat.spi.NTTStrategy;

public class LongAparapiNTTBuilder
extends LongNTTBuilder {
    private static final int MIN_GPU_LENGTH = 0x100000;
    private boolean rowOrientation;

    public LongAparapiNTTBuilder(boolean rowOrientation) {
        this.rowOrientation = rowOrientation;
    }

    protected NTTStrategy createSixStepFNTStrategy(long size) {
        long length = size;
        if (length < 0x100000L) {
            return super.createSixStepFNTStrategy(size);
        }
        return this.rowOrientation ? new LongAparapiSixStepFNTStrategy() : new LongAparapiColumnSixStepFNTStrategy();
    }

    protected NTTStrategy createTwoPassFNTStrategy(long size) {
        long length = size;
        if (length < 0x100000L) {
            return super.createTwoPassFNTStrategy(size);
        }
        return this.rowOrientation ? new LongAparapiTwoPassFNTStrategy() : new LongAparapiColumnTwoPassFNTStrategy();
    }

    protected NTTStrategy createFactor3NTTStrategy(long size, NTTStrategy nttStrategy) {
        if (nttStrategy instanceof LongAparapiNTTStrategy) {
            ApfloatContext ctx = ApfloatContext.getContext();
            BuilderFactory builderFactory = ctx.getBuilderFactory();
            long maxMemoryBlockSize = ctx.getMaxMemoryBlockSize() / (long)builderFactory.getElementSize();
            if (size <= maxMemoryBlockSize && size <= Integer.MAX_VALUE) {
                return new LongAparapiFactor3NTTStrategy(nttStrategy);
            }
        }
        return super.createFactor3NTTStrategy(size, nttStrategy);
    }
}

