/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.aparapi;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import org.apfloat.aparapi.IntKernel;
import org.apfloat.internal.NTTStrategyDecorator;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.NTTStrategy;

public interface IntAparapiNTTStrategy
extends NTTStrategy,
NTTStrategyDecorator {
    public static final ThreadLocal<AtomicInteger> LEVEL = ThreadLocal.withInitial(AtomicInteger::new);
    public static final ThreadLocal<WeakReference<int[]>> DATA = ThreadLocal.withInitial(() -> new WeakReference<Object>(null));

    default public void beforeTransform(ArrayAccess arrayAccess) {
        int[] data = arrayAccess.getIntData();
        AtomicInteger currentLevel = LEVEL.get();
        int[] currentData = (int[])DATA.get().get();
        if (currentLevel.get() == 0 || data != currentData) {
            IntKernel kernel = IntKernel.getInstance();
            kernel.setExplicit(true);
            kernel.put(data);
            DATA.set(new WeakReference<int[]>(data));
            currentLevel.set(0);
        }
        currentLevel.incrementAndGet();
    }

    default public void afterTransform(ArrayAccess arrayAccess) {
        AtomicInteger level = LEVEL.get();
        int currentLevel = level.decrementAndGet();
        if (currentLevel == 0) {
            IntKernel kernel = IntKernel.getInstance();
            kernel.get(arrayAccess.getIntData());
            kernel.cleanUpArrays();
        }
    }
}

