/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.ValidationPercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.table.BorderSpecification;
import org.apache.fop.fo.flow.table.ColumnNumberManager;
import org.apache.fop.fo.flow.table.ColumnNumberManagerHolder;
import org.apache.fop.fo.flow.table.ConditionalBorder;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.layoutmgr.table.CollapsingBorderModel;
import org.xml.sax.Locator;

public abstract class TableFObj
extends FObj {
    private Numeric borderAfterPrecedence;
    private Numeric borderBeforePrecedence;
    private Numeric borderEndPrecedence;
    private Numeric borderStartPrecedence;
    ConditionalBorder borderBefore;
    ConditionalBorder borderAfter;
    BorderSpecification borderStart;
    BorderSpecification borderEnd;
    CollapsingBorderModel collapsingBorderModel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TableFObj(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.borderAfterPrecedence = pList.get(20).getNumeric();
        this.borderBeforePrecedence = pList.get(24).getNumeric();
        this.borderEndPrecedence = pList.get(34).getNumeric();
        this.borderStartPrecedence = pList.get(48).getNumeric();
        if (this.getNameId() != 46 && this.getNameId() != 50 && this.getCommonBorderPaddingBackground().hasPadding(ValidationPercentBaseContext.getPseudoContext())) {
            this.attributeWarning("padding-* properties are not applicable to " + this.getName() + ", but a non-zero value for padding was found.");
        }
    }

    public Numeric getBorderPrecedence(int side) {
        switch (side) {
            case 0: {
                return this.borderBeforePrecedence;
            }
            case 1: {
                return this.borderAfterPrecedence;
            }
            case 2: {
                return this.borderStartPrecedence;
            }
            case 3: {
                return this.borderEndPrecedence;
            }
        }
        return null;
    }

    public Table getTable() {
        return ((TableFObj)this.parent).getTable();
    }

    public abstract CommonBorderPaddingBackground getCommonBorderPaddingBackground();

    public void startOfNode() throws FOPException {
        super.startOfNode();
        Table table = this.getTable();
        if (!this.inMarker() && !table.isSeparateBorderModel()) {
            this.collapsingBorderModel = CollapsingBorderModel.getBorderModelFor(table.getBorderCollapse());
            this.setCollapsedBorders();
        }
    }

    public void endOfNode() throws FOPException {
        super.endOfNode();
    }

    protected abstract void setCollapsedBorders();

    protected void createBorder(int side) {
        BorderSpecification borderSpec = new BorderSpecification(this.getCommonBorderPaddingBackground().getBorderInfo(side), this.getNameId());
        switch (side) {
            case 0: {
                this.borderBefore = new ConditionalBorder(borderSpec, this.collapsingBorderModel);
                break;
            }
            case 1: {
                this.borderAfter = new ConditionalBorder(borderSpec, this.collapsingBorderModel);
                break;
            }
            case 2: {
                this.borderStart = borderSpec;
                break;
            }
            case 3: {
                this.borderEnd = borderSpec;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    protected void createBorder(int side, TableFObj competitor) {
        this.createBorder(side);
        switch (side) {
            case 0: {
                this.borderBefore.integrateSegment(competitor.borderBefore, true, true, true);
                break;
            }
            case 1: {
                this.borderAfter.integrateSegment(competitor.borderAfter, true, true, true);
                break;
            }
            case 2: {
                this.borderStart = this.collapsingBorderModel.determineWinner(this.borderStart, competitor.borderStart);
                break;
            }
            case 3: {
                this.borderEnd = this.collapsingBorderModel.determineWinner(this.borderEnd, competitor.borderEnd);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    static {
        $assertionsDisabled = !TableFObj.class.desiredAssertionStatus();
    }

    public static class ColumnNumberPropertyMaker
    extends NumberProperty.Maker {
        public ColumnNumberPropertyMaker(int propId) {
            super(propId);
        }

        public Property make(PropertyList propertyList) throws PropertyException {
            FObj fo = propertyList.getFObj();
            return NumberProperty.getInstance(((ColumnNumberManagerHolder)((Object)fo.getParent())).getColumnNumberManager().getCurrentColumnNumber());
        }

        public Property make(PropertyList propertyList, String value, FObj fo) throws PropertyException {
            Property p = super.make(propertyList, value, fo);
            ColumnNumberManagerHolder parent = (ColumnNumberManagerHolder)((Object)propertyList.getParentFObj());
            ColumnNumberManager columnIndexManager = parent.getColumnNumberManager();
            int columnIndex = p.getNumeric().getValue();
            if (columnIndex <= 0) {
                log.warn((Object)("Specified negative or zero value for column-number on " + fo.getName() + ": " + columnIndex + " forced to " + columnIndexManager.getCurrentColumnNumber()));
                return NumberProperty.getInstance(columnIndexManager.getCurrentColumnNumber());
            }
            double tmpIndex = p.getNumeric().getNumericValue();
            if (tmpIndex - (double)columnIndex > 0.0) {
                columnIndex = (int)Math.round(tmpIndex);
                log.warn((Object)("Rounding specified column-number of " + tmpIndex + " to " + columnIndex));
                p = NumberProperty.getInstance(columnIndex);
            }
            int colSpan = propertyList.get(149).getNumeric().getValue();
            int i = -1;
            while (++i < colSpan) {
                if (!columnIndexManager.isColumnNumberUsed(columnIndex + i)) continue;
                StringBuffer errorMessage = new StringBuffer();
                errorMessage.append(fo.getName() + " overlaps in column ").append(columnIndex + i);
                Locator loc = fo.getLocator();
                if (loc != null && loc.getLineNumber() != -1) {
                    errorMessage.append(" (line #").append(loc.getLineNumber()).append(", column #").append(loc.getColumnNumber()).append(")");
                }
                throw new PropertyException(errorMessage.toString());
            }
            return p;
        }
    }
}

