/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.autodetect;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CachedFontInfo;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;

public class FontInfoFinder {
    private Log log = LogFactory.getLog((Class)FontInfoFinder.class);
    private final Pattern quotePattern = Pattern.compile("'");

    private void generateTripletsFromFont(CustomFont customFont, Collection triplets) {
        int guessedWeight;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Font: " + customFont.getFullName() + ", family: " + customFont.getFamilyNames() + ", PS: " + customFont.getFontName() + ", EmbedName: " + customFont.getEmbedFontName()));
        }
        String strippedName = this.stripQuotes(customFont.getStrippedFontName());
        String fullName = this.stripQuotes(customFont.getFullName());
        String searchName = fullName.toLowerCase();
        String style = this.guessStyle(customFont, searchName);
        int weight = guessedWeight = FontUtil.guessWeight(searchName);
        triplets.add(new FontTriplet(fullName, "normal", 400, 0));
        if (!fullName.equals(strippedName)) {
            triplets.add(new FontTriplet(strippedName, "normal", 400, 0));
        }
        Set familyNames = customFont.getFamilyNames();
        Iterator iter = familyNames.iterator();
        while (iter.hasNext()) {
            String familyName = this.stripQuotes((String)iter.next());
            if (fullName.equals(familyName)) continue;
            int priority = fullName.startsWith(familyName) ? fullName.length() - familyName.length() : fullName.length();
            triplets.add(new FontTriplet(familyName, style, weight, priority));
        }
    }

    private String stripQuotes(String name) {
        return this.quotePattern.matcher(name).replaceAll("");
    }

    private String guessStyle(CustomFont customFont, String fontName) {
        String style = "normal";
        style = customFont.getItalicAngle() > 0 ? "italic" : FontUtil.guessStyle(fontName);
        return style;
    }

    private EmbedFontInfo fontInfoFromCustomFont(URL fontUrl, CustomFont customFont, FontCache fontCache) {
        ArrayList fontTripletList = new ArrayList();
        this.generateTripletsFromFont(customFont, fontTripletList);
        String embedUrl = fontUrl.toExternalForm();
        EmbedFontInfo fontInfo = new EmbedFontInfo(null, customFont.isKerningEnabled(), fontTripletList, embedUrl);
        if (fontCache != null) {
            fontCache.addFont(fontInfo);
        }
        return fontInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbedFontInfo find(URL fontUrl, FontResolver resolver, FontCache fontCache) {
        String embedUrl = null;
        embedUrl = fontUrl.toExternalForm();
        long fileLastModified = -1L;
        if (fontCache != null) {
            try {
                URLConnection conn = fontUrl.openConnection();
                try {
                    fileLastModified = conn.getLastModified();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)conn.getInputStream());
                }
            }
            catch (IOException e) {
                this.log.debug((Object)("IOError: " + e.getMessage()));
                fileLastModified = 0L;
            }
            if (fontCache.containsFont(embedUrl)) {
                CachedFontInfo fontInfo = fontCache.getFont(embedUrl);
                if (fontInfo.lastModified() == fileLastModified) {
                    return fontInfo;
                }
                fontCache.removeFont(embedUrl);
            } else if (fontCache.isFailedFont(embedUrl, fileLastModified)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Skipping font file that failed to load previously: " + embedUrl));
                }
                return null;
            }
        }
        CustomFont customFont = null;
        try {
            customFont = FontLoader.loadFont(fontUrl, resolver);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Unable to load font file: " + embedUrl + ". Reason: " + e.getMessage()));
            }
            if (fontCache != null) {
                fontCache.registerFailedFont(embedUrl, fileLastModified);
            }
            return null;
        }
        return this.fontInfoFromCustomFont(fontUrl, customFont, fontCache);
    }
}

