/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.render.AbstractFOEventHandlerMaker;
import org.apache.fop.render.AbstractRendererMaker;
import org.apache.fop.render.Renderer;
import org.apache.xmlgraphics.util.Service;

public class RendererFactory {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$render$RendererFactory == null ? (class$org$apache$fop$render$RendererFactory = RendererFactory.class$("org.apache.fop.render.RendererFactory")) : class$org$apache$fop$render$RendererFactory));
    private Map rendererMakerMapping = new HashMap();
    private Map eventHandlerMakerMapping = new HashMap();
    static /* synthetic */ Class class$org$apache$fop$render$RendererFactory;
    static /* synthetic */ Class class$org$apache$fop$render$AbstractRendererMaker;
    static /* synthetic */ Class class$org$apache$fop$render$AbstractFOEventHandlerMaker;
    static /* synthetic */ Class class$org$apache$fop$render$Renderer;
    static /* synthetic */ Class class$org$apache$fop$fo$FOEventHandler;

    public RendererFactory() {
        this.discoverRenderers();
        this.discoverFOEventHandlers();
    }

    public void addRendererMaker(AbstractRendererMaker maker) {
        String[] mimes = maker.getSupportedMimeTypes();
        for (int i = 0; i < mimes.length; ++i) {
            if (this.rendererMakerMapping.get(mimes[i]) != null) {
                log.trace((Object)("Overriding renderer for " + mimes[i] + " with " + maker.getClass().getName()));
            }
            this.rendererMakerMapping.put(mimes[i], maker);
        }
    }

    public void addFOEventHandlerMaker(AbstractFOEventHandlerMaker maker) {
        String[] mimes = maker.getSupportedMimeTypes();
        for (int i = 0; i < mimes.length; ++i) {
            if (this.eventHandlerMakerMapping.get(mimes[i]) != null) {
                log.trace((Object)("Overriding FOEventHandler for " + mimes[i] + " with " + maker.getClass().getName()));
            }
            this.eventHandlerMakerMapping.put(mimes[i], maker);
        }
    }

    public void addRendererMaker(String className) {
        try {
            AbstractRendererMaker makerInstance = (AbstractRendererMaker)Class.forName(className).newInstance();
            this.addRendererMaker(makerInstance);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + className);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + className);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + className);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(className + " is not an " + (class$org$apache$fop$render$AbstractRendererMaker == null ? (class$org$apache$fop$render$AbstractRendererMaker = RendererFactory.class$("org.apache.fop.render.AbstractRendererMaker")) : class$org$apache$fop$render$AbstractRendererMaker).getName());
        }
    }

    public void addFOEventHandlerMaker(String className) {
        try {
            AbstractFOEventHandlerMaker makerInstance = (AbstractFOEventHandlerMaker)Class.forName(className).newInstance();
            this.addFOEventHandlerMaker(makerInstance);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + className);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + className);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + className);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(className + " is not an " + (class$org$apache$fop$render$AbstractFOEventHandlerMaker == null ? (class$org$apache$fop$render$AbstractFOEventHandlerMaker = RendererFactory.class$("org.apache.fop.render.AbstractFOEventHandlerMaker")) : class$org$apache$fop$render$AbstractFOEventHandlerMaker).getName());
        }
    }

    public AbstractRendererMaker getRendererMaker(String mime) {
        AbstractRendererMaker maker = (AbstractRendererMaker)this.rendererMakerMapping.get(mime);
        return maker;
    }

    public AbstractFOEventHandlerMaker getFOEventHandlerMaker(String mime) {
        AbstractFOEventHandlerMaker maker = (AbstractFOEventHandlerMaker)this.eventHandlerMakerMapping.get(mime);
        return maker;
    }

    public Renderer createRenderer(FOUserAgent userAgent, String outputFormat) throws FOPException {
        if (userAgent.getRendererOverride() != null) {
            return userAgent.getRendererOverride();
        }
        AbstractRendererMaker maker = this.getRendererMaker(outputFormat);
        if (maker == null) {
            throw new UnsupportedOperationException("No renderer for the requested format available: " + outputFormat);
        }
        Renderer rend = maker.makeRenderer(userAgent);
        rend.setUserAgent(userAgent);
        String mimeType = rend.getMimeType();
        Configuration userRendererConfig = null;
        if (mimeType != null) {
            userRendererConfig = userAgent.getUserRendererConfig(mimeType);
        }
        if (userRendererConfig != null) {
            try {
                ContainerUtil.configure((Object)rend, (Configuration)userRendererConfig);
            }
            catch (ConfigurationException e) {
                throw new FOPException((Exception)((Object)e));
            }
        }
        return rend;
    }

    public FOEventHandler createFOEventHandler(FOUserAgent userAgent, String outputFormat, OutputStream out) throws FOPException {
        if (userAgent.getFOEventHandlerOverride() != null) {
            return userAgent.getFOEventHandlerOverride();
        }
        AbstractFOEventHandlerMaker maker = this.getFOEventHandlerMaker(outputFormat);
        if (maker == null) {
            AbstractRendererMaker rendMaker = this.getRendererMaker(outputFormat);
            if (rendMaker == null && userAgent.getRendererOverride() == null) {
                throw new UnsupportedOperationException("Don't know how to handle \"" + outputFormat + "\" as an output format." + " Neither an FOEventHandler, nor a Renderer could be found" + " for this output format.");
            }
            if (out == null && userAgent.getRendererOverride() == null && rendMaker.needsOutputStream()) {
                throw new FOPException("OutputStream has not been set");
            }
            return new AreaTreeHandler(userAgent, outputFormat, out);
        }
        return maker.makeFOEventHandler(userAgent, out);
    }

    public String[] listSupportedMimeTypes() {
        ArrayList<String> lst = new ArrayList<String>();
        Iterator iter = this.rendererMakerMapping.keySet().iterator();
        while (iter.hasNext()) {
            lst.add((String)iter.next());
        }
        iter = this.eventHandlerMakerMapping.keySet().iterator();
        while (iter.hasNext()) {
            lst.add((String)iter.next());
        }
        Collections.sort(lst);
        return lst.toArray(new String[lst.size()]);
    }

    private void discoverRenderers() {
        Iterator providers = Service.providers((Class)(class$org$apache$fop$render$Renderer == null ? (class$org$apache$fop$render$Renderer = RendererFactory.class$("org.apache.fop.render.Renderer")) : class$org$apache$fop$render$Renderer));
        if (providers != null) {
            while (providers.hasNext()) {
                AbstractRendererMaker maker = (AbstractRendererMaker)providers.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dynamically adding maker for Renderer: " + maker.getClass().getName()));
                    }
                    this.addRendererMaker(maker);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)"Error while adding maker for Renderer", (Throwable)e);
                }
            }
        }
    }

    private void discoverFOEventHandlers() {
        Iterator providers = Service.providers((Class)(class$org$apache$fop$fo$FOEventHandler == null ? (class$org$apache$fop$fo$FOEventHandler = RendererFactory.class$("org.apache.fop.fo.FOEventHandler")) : class$org$apache$fop$fo$FOEventHandler));
        if (providers != null) {
            while (providers.hasNext()) {
                AbstractFOEventHandlerMaker maker = (AbstractFOEventHandlerMaker)providers.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dynamically adding maker for FOEventHandler: " + maker.getClass().getName()));
                    }
                    this.addFOEventHandlerMaker(maker);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)"Error while adding maker for FOEventHandler", (Throwable)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

