/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.analyser.ImageReader;

public class TIFFReader
implements ImageReader {
    private static final int TIFF_SIG_LENGTH = 8;

    public FopImage.ImageInfo verifySignature(String uri, InputStream bis, FOUserAgent ua) throws IOException {
        byte[] header = this.getDefaultHeader(bis);
        boolean supported = false;
        if (header[0] == 73 && header[1] == 73 && header[2] == 42 && header[3] == 0) {
            supported = true;
        }
        if (header[0] == 77 && header[1] == 77 && header[2] == 0 && header[3] == 42) {
            supported = true;
        }
        if (supported) {
            FopImage.ImageInfo info = this.getDimension(header);
            info.originalURI = uri;
            info.mimeType = this.getMimeType();
            info.inputStream = bis;
            return info;
        }
        return null;
    }

    public String getMimeType() {
        return "image/tiff";
    }

    private FopImage.ImageInfo getDimension(byte[] header) {
        FopImage.ImageInfo info = new FopImage.ImageInfo();
        info.width = -1;
        info.height = -1;
        return info;
    }

    private byte[] getDefaultHeader(InputStream imageStream) throws IOException {
        byte[] header = new byte[8];
        try {
            imageStream.mark(9);
            imageStream.read(header);
            imageStream.reset();
        }
        catch (IOException ex) {
            try {
                imageStream.reset();
            }
            catch (IOException exbis) {
                // empty catch block
            }
            throw ex;
        }
        return header;
    }
}

