/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.terminal.telnet;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.xbean.terminal.telnet.TelnetShell;

public class TelnetDaemon
implements Runnable {
    private final TelnetShell shell;
    private final int port;
    private ServerSocket serverSocket;
    private boolean stop = true;

    public TelnetDaemon(String serverName, int port) {
        this.port = port;
        this.shell = new TelnetShell(serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        TelnetDaemon telnetDaemon = this;
        synchronized (telnetDaemon) {
            if (!this.stop) {
                return;
            }
            this.stop = false;
            try {
                this.serverSocket = new ServerSocket(this.port, 20);
                Thread d = new Thread(this);
                d.setName("service.shell@" + d.hashCode());
                d.setDaemon(true);
                d.start();
            }
            catch (Exception e) {
                throw new Exception("Service failed to start.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        TelnetDaemon telnetDaemon = this;
        synchronized (telnetDaemon) {
            if (this.stop) {
                return;
            }
            this.stop = true;
            try {
                this.notifyAll();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public synchronized void service(final Socket socket) throws IOException {
        Thread d = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    TelnetDaemon.this.shell.service(socket);
                }
                catch (SecurityException e) {
                }
                catch (Throwable e) {
                }
                finally {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Throwable t) {}
                }
            }
        });
        d.setDaemon(true);
        d.start();
    }

    public void run() {
        Socket socket = null;
        while (!this.stop) {
            try {
                socket = this.serverSocket.accept();
                socket.setTcpNoDelay(true);
                if (this.stop) continue;
                this.service(socket);
            }
            catch (SecurityException e) {
            }
            catch (Throwable throwable) {}
        }
    }
}

