/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import org.apache.xbean.propertyeditor.PropertyEditorException;
import org.apache.xbean.propertyeditor.PropertyEditors;
import org.apache.xbean.recipe.AbstractRecipe;
import org.apache.xbean.recipe.ConstructionException;

public class ValueRecipe
extends AbstractRecipe {
    private final String type;
    private final String value;

    public ValueRecipe(Class type, String value) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (!PropertyEditors.canConvert(type)) {
            throw new IllegalArgumentException("No converter available for " + type.getSimpleName());
        }
        this.type = type.getName();
        this.value = value;
    }

    public ValueRecipe(String type, String value) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.type = type;
        this.value = value;
    }

    public ValueRecipe(Object value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.type = value.getClass().getName();
        this.value = PropertyEditors.toString(value);
    }

    public ValueRecipe(ValueRecipe valueRecipe) {
        if (valueRecipe == null) {
            throw new NullPointerException("valueRecipe is null");
        }
        this.type = valueRecipe.type;
        this.value = valueRecipe.value;
    }

    public boolean canCreate(Class type, ClassLoader classLoader) {
        try {
            Class<?> myType = Class.forName(this.type, true, classLoader);
            return type.isAssignableFrom(myType);
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Type class could not be found: " + type);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public Object create(ClassLoader classLoader) {
        if (this.value == null) {
            return null;
        }
        try {
            return PropertyEditors.getValue(this.type, this.value, classLoader);
        }
        catch (PropertyEditorException e) {
            throw new ConstructionException(e);
        }
    }
}

