/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.util.Map;
import java.util.Properties;
import org.apache.xbean.recipe.AbstractSecretRecipe;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Recipe;

public class UnsetPropertiesRecipe
extends AbstractSecretRecipe {
    public float getPriority() {
        return 100.0f;
    }

    public boolean canCreate(Class type, ClassLoader classLoader) {
        return type.isAssignableFrom(Properties.class);
    }

    public Object create(Recipe outerRecipe, ClassLoader classLoader) throws ConstructionException {
        if (!(outerRecipe instanceof ObjectRecipe)) {
            throw new ConstructionException("UnsetPropertiesRecipe can only be nested in an ObjectRecipe: outerRecipe=" + outerRecipe);
        }
        ObjectRecipe objectRecipe = (ObjectRecipe)outerRecipe;
        Map<String, Object> unsetProperties = objectRecipe.getUnsetProperties();
        Properties properties = new Properties();
        for (Map.Entry<String, Object> entry : unsetProperties.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }
}

