/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean;

import java.lang.reflect.Array;
import java.util.HashMap;

public class ClassLoading {
    private static final HashMap PRIMITIVE_CLASS_MAP = new HashMap();
    private static final HashMap CLASS_TO_SIGNATURE_MAP = new HashMap();

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader is null");
        }
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ignore) {
            Class resolvedClass = (Class)PRIMITIVE_CLASS_MAP.get(className);
            if (resolvedClass != null) {
                return resolvedClass;
            }
            if (className.endsWith(";") && className.startsWith("L")) {
                String typeName = className.substring(1, className.length() - 1);
                return classLoader.loadClass(typeName);
            }
            if (className.charAt(0) == '[') {
                int count;
                int nameLen = className.length();
                for (count = 0; count < nameLen && className.charAt(count) == '['; ++count) {
                }
                String arrayTypeName = className.substring(count, className.length());
                Class arrayType = ClassLoading.loadClass(arrayTypeName, classLoader);
                return ClassLoading.getArrayClass(arrayType, count);
            }
            if (className.endsWith("[]")) {
                int position;
                int count = 0;
                for (position = className.length(); position > 1 && className.substring(position - 2, position).equals("[]"); position -= 2) {
                    ++count;
                }
                String typeName = className.substring(0, position);
                Class arrayType = ClassLoading.loadClass(typeName, classLoader);
                return ClassLoading.getArrayClass(arrayType, count);
            }
            throw new ClassNotFoundException(className);
        }
    }

    public static String getClassName(Class type) {
        return ClassLoading.getClassName(type, false);
    }

    public static String getClassName(Object instance) {
        return ClassLoading.getClassName(instance, false);
    }

    public static String getClassName(Object instance, boolean pretty) {
        if (instance == null) {
            return "null";
        }
        return ClassLoading.getClassName(instance.getClass(), pretty);
    }

    public static String getClassName(Class type, boolean pretty) {
        StringBuffer name = new StringBuffer();
        while (type.isArray()) {
            name.append('[');
            if (pretty) {
                name.append(']');
            }
            type = type.getComponentType();
        }
        if (type.isPrimitive()) {
            if (pretty) {
                name.insert(0, type.getName());
            } else {
                name.append((String)CLASS_TO_SIGNATURE_MAP.get(type));
            }
        } else if (pretty) {
            name.insert(0, type.getName());
        } else {
            name.append('L');
            name.append(type.getName());
            name.append(';');
        }
        return name.toString();
    }

    private static Class getArrayClass(Class type, int dimension) {
        int[] dimensions = new int[dimension];
        return Array.newInstance(type, dimensions).getClass();
    }

    static {
        PRIMITIVE_CLASS_MAP.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASS_MAP.put("Z", Boolean.TYPE);
        PRIMITIVE_CLASS_MAP.put("byte", Byte.TYPE);
        PRIMITIVE_CLASS_MAP.put("B", Byte.TYPE);
        PRIMITIVE_CLASS_MAP.put("char", Character.TYPE);
        PRIMITIVE_CLASS_MAP.put("C", Character.TYPE);
        PRIMITIVE_CLASS_MAP.put("short", Short.TYPE);
        PRIMITIVE_CLASS_MAP.put("S", Short.TYPE);
        PRIMITIVE_CLASS_MAP.put("int", Integer.TYPE);
        PRIMITIVE_CLASS_MAP.put("I", Integer.TYPE);
        PRIMITIVE_CLASS_MAP.put("long", Long.TYPE);
        PRIMITIVE_CLASS_MAP.put("J", Long.TYPE);
        PRIMITIVE_CLASS_MAP.put("float", Float.TYPE);
        PRIMITIVE_CLASS_MAP.put("F", Float.TYPE);
        PRIMITIVE_CLASS_MAP.put("double", Double.TYPE);
        PRIMITIVE_CLASS_MAP.put("D", Double.TYPE);
        PRIMITIVE_CLASS_MAP.put("void", Void.TYPE);
        PRIMITIVE_CLASS_MAP.put("V", Void.TYPE);
        CLASS_TO_SIGNATURE_MAP.put(Boolean.TYPE, "Z");
        CLASS_TO_SIGNATURE_MAP.put(Byte.TYPE, "B");
        CLASS_TO_SIGNATURE_MAP.put(Character.TYPE, "C");
        CLASS_TO_SIGNATURE_MAP.put(Short.TYPE, "S");
        CLASS_TO_SIGNATURE_MAP.put(Integer.TYPE, "I");
        CLASS_TO_SIGNATURE_MAP.put(Long.TYPE, "J");
        CLASS_TO_SIGNATURE_MAP.put(Float.TYPE, "F");
        CLASS_TO_SIGNATURE_MAP.put(Double.TYPE, "D");
        CLASS_TO_SIGNATURE_MAP.put(Void.TYPE, "V");
    }
}

