/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.xbean.ClassLoading;
import org.apache.xbean.propertyeditor.ArrayConverter;
import org.apache.xbean.propertyeditor.ArrayListEditor;
import org.apache.xbean.propertyeditor.BigDecimalEditor;
import org.apache.xbean.propertyeditor.BigIntegerEditor;
import org.apache.xbean.propertyeditor.BooleanEditor;
import org.apache.xbean.propertyeditor.ByteEditor;
import org.apache.xbean.propertyeditor.CharacterEditor;
import org.apache.xbean.propertyeditor.ClassEditor;
import org.apache.xbean.propertyeditor.Converter;
import org.apache.xbean.propertyeditor.DateEditor;
import org.apache.xbean.propertyeditor.DoubleEditor;
import org.apache.xbean.propertyeditor.FileEditor;
import org.apache.xbean.propertyeditor.FloatEditor;
import org.apache.xbean.propertyeditor.HashMapEditor;
import org.apache.xbean.propertyeditor.HashtableEditor;
import org.apache.xbean.propertyeditor.IdentityHashMapEditor;
import org.apache.xbean.propertyeditor.Inet4AddressEditor;
import org.apache.xbean.propertyeditor.Inet6AddressEditor;
import org.apache.xbean.propertyeditor.InetAddressEditor;
import org.apache.xbean.propertyeditor.IntegerEditor;
import org.apache.xbean.propertyeditor.LinkedHashMapEditor;
import org.apache.xbean.propertyeditor.LinkedHashSetEditor;
import org.apache.xbean.propertyeditor.LinkedListEditor;
import org.apache.xbean.propertyeditor.ListEditor;
import org.apache.xbean.propertyeditor.LongEditor;
import org.apache.xbean.propertyeditor.MapEditor;
import org.apache.xbean.propertyeditor.ObjectNameEditor;
import org.apache.xbean.propertyeditor.PropertiesEditor;
import org.apache.xbean.propertyeditor.PropertyEditorException;
import org.apache.xbean.propertyeditor.ReferenceIdentityMap;
import org.apache.xbean.propertyeditor.SetEditor;
import org.apache.xbean.propertyeditor.ShortEditor;
import org.apache.xbean.propertyeditor.SortedMapEditor;
import org.apache.xbean.propertyeditor.SortedSetEditor;
import org.apache.xbean.propertyeditor.StringEditor;
import org.apache.xbean.propertyeditor.TreeMapEditor;
import org.apache.xbean.propertyeditor.TreeSetEditor;
import org.apache.xbean.propertyeditor.URIEditor;
import org.apache.xbean.propertyeditor.URLEditor;
import org.apache.xbean.propertyeditor.VectorEditor;
import org.apache.xbean.propertyeditor.WeakHashMapEditor;

public class PropertyEditors {
    private static final Map registry = Collections.synchronizedMap(new ReferenceIdentityMap());
    private static final Map PRIMITIVE_TO_WRAPPER;
    private static final Map WRAPPER_TO_PRIMITIVE;
    static /* synthetic */ Class class$org$apache$xbean$propertyeditor$Converter;

    public static void registerConverter(Converter converter) {
        if (converter == null) {
            throw new NullPointerException("editor is null");
        }
        Class type = converter.getType();
        registry.put(type, converter);
        PropertyEditorManager.registerEditor(type, converter.getClass());
        if (PRIMITIVE_TO_WRAPPER.containsKey(type)) {
            Class wrapperType = (Class)PRIMITIVE_TO_WRAPPER.get(type);
            registry.put(wrapperType, converter);
            PropertyEditorManager.registerEditor(wrapperType, converter.getClass());
        } else if (WRAPPER_TO_PRIMITIVE.containsKey(type)) {
            Class primitiveType = (Class)WRAPPER_TO_PRIMITIVE.get(type);
            registry.put(primitiveType, converter);
            PropertyEditorManager.registerEditor(primitiveType, converter.getClass());
        }
    }

    public static boolean canConvert(String type, ClassLoader classLoader) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        Class typeClass = null;
        try {
            typeClass = ClassLoading.loadClass(type, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new PropertyEditorException("Type class could not be found: " + type);
        }
        return PropertyEditors.canConvert(typeClass);
    }

    public static boolean canConvert(Class type) {
        Converter converter = PropertyEditors.findConverter(type);
        if (converter != null) {
            return true;
        }
        PropertyEditor editor = PropertyEditors.findEditor(type);
        return editor != null;
    }

    public static String toString(Object value) throws PropertyEditorException {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        Class<?> type = value.getClass();
        Converter converter = PropertyEditors.findConverter(type);
        if (converter != null) {
            return converter.toString(value);
        }
        PropertyEditor editor = PropertyEditors.findEditor(type);
        if (editor == null) {
            throw new PropertyEditorException("Unable to find PropertyEditor for " + ClassLoading.getClassName(type, true));
        }
        editor.setValue(value);
        String textValue = null;
        try {
            textValue = editor.getAsText();
        }
        catch (Exception e) {
            throw new PropertyEditorException("Error while converting a \"" + ClassLoading.getClassName(type, true) + "\" to text " + " using the property editor " + ClassLoading.getClassName(editor.getClass(), true), e);
        }
        return textValue;
    }

    public static Object getValue(String type, String value, ClassLoader classLoader) throws PropertyEditorException {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        Class typeClass = null;
        try {
            typeClass = ClassLoading.loadClass(type, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new PropertyEditorException("Type class could not be found: " + type);
        }
        return PropertyEditors.getValue(typeClass, value);
    }

    public static Object getValue(Class type, String value) throws PropertyEditorException {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        Converter converter = PropertyEditors.findConverter(type);
        if (converter != null) {
            return converter.toObject(value);
        }
        PropertyEditor editor = PropertyEditors.findEditor(type);
        if (editor == null) {
            throw new PropertyEditorException("Unable to find PropertyEditor for " + ClassLoading.getClassName(type, true));
        }
        editor.setAsText(value);
        Object objectValue = null;
        try {
            objectValue = editor.getValue();
        }
        catch (Exception e) {
            throw new PropertyEditorException("Error while converting \"" + value + "\" to a " + ClassLoading.getClassName(type, true) + " using the property editor " + ClassLoading.getClassName(editor.getClass(), true), e);
        }
        return objectValue;
    }

    private static Converter findConverter(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        Converter converter = (Converter)registry.get(type);
        if (converter != null) {
            return converter;
        }
        Class<?>[] declaredClasses = type.getDeclaredClasses();
        for (int i = 0; i < declaredClasses.length; ++i) {
            Class<?> declaredClass;
            if (!(class$org$apache$xbean$propertyeditor$Converter == null ? PropertyEditors.class$("org.apache.xbean.propertyeditor.Converter") : class$org$apache$xbean$propertyeditor$Converter).isAssignableFrom(declaredClass = declaredClasses[i])) continue;
            try {
                converter = (Converter)declaredClass.newInstance();
                PropertyEditors.registerConverter(converter);
                converter = (Converter)registry.get(type);
                if (converter == null) continue;
                return converter;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (type.isArray() && !type.getComponentType().isArray() && (converter = PropertyEditors.findConverter(type.getComponentType())) != null) {
            return new ArrayConverter(type, converter);
        }
        return null;
    }

    private static PropertyEditor findEditor(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            return editor;
        }
        if (type.isArray() && !type.getComponentType().isArray() && (editor = PropertyEditors.findEditor(type.getComponentType())) != null) {
            return new ArrayConverter(type, editor);
        }
        return null;
    }

    static {
        HashMap<Class, Class<Comparable<Boolean>>> map = new HashMap<Class, Class<Comparable<Boolean>>>();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Character.TYPE, Character.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPER = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(Boolean.class, Boolean.TYPE);
        map.put(Character.class, Character.TYPE);
        map.put(Byte.class, Byte.TYPE);
        map.put(Short.class, Short.TYPE);
        map.put(Integer.class, Integer.TYPE);
        map.put(Long.class, Long.TYPE);
        map.put(Float.class, Float.TYPE);
        map.put(Double.class, Double.TYPE);
        WRAPPER_TO_PRIMITIVE = Collections.unmodifiableMap(map);
        PropertyEditors.registerConverter(new ArrayListEditor());
        PropertyEditors.registerConverter(new BigDecimalEditor());
        PropertyEditors.registerConverter(new BigIntegerEditor());
        PropertyEditors.registerConverter(new BooleanEditor());
        PropertyEditors.registerConverter(new ByteEditor());
        PropertyEditors.registerConverter(new CharacterEditor());
        PropertyEditors.registerConverter(new ClassEditor());
        PropertyEditors.registerConverter(new DateEditor());
        PropertyEditors.registerConverter(new DoubleEditor());
        PropertyEditors.registerConverter(new FileEditor());
        PropertyEditors.registerConverter(new FloatEditor());
        PropertyEditors.registerConverter(new HashMapEditor());
        PropertyEditors.registerConverter(new HashtableEditor());
        PropertyEditors.registerConverter(new IdentityHashMapEditor());
        PropertyEditors.registerConverter(new Inet4AddressEditor());
        PropertyEditors.registerConverter(new Inet6AddressEditor());
        PropertyEditors.registerConverter(new InetAddressEditor());
        PropertyEditors.registerConverter(new IntegerEditor());
        PropertyEditors.registerConverter(new LinkedHashMapEditor());
        PropertyEditors.registerConverter(new LinkedHashSetEditor());
        PropertyEditors.registerConverter(new LinkedListEditor());
        PropertyEditors.registerConverter(new ListEditor());
        PropertyEditors.registerConverter(new LongEditor());
        PropertyEditors.registerConverter(new MapEditor());
        PropertyEditors.registerConverter(new ObjectNameEditor());
        PropertyEditors.registerConverter(new PropertiesEditor());
        PropertyEditors.registerConverter(new SetEditor());
        PropertyEditors.registerConverter(new ShortEditor());
        PropertyEditors.registerConverter(new SortedMapEditor());
        PropertyEditors.registerConverter(new SortedSetEditor());
        PropertyEditors.registerConverter(new StringEditor());
        PropertyEditors.registerConverter(new TreeMapEditor());
        PropertyEditors.registerConverter(new TreeSetEditor());
        PropertyEditors.registerConverter(new URIEditor());
        PropertyEditors.registerConverter(new URLEditor());
        PropertyEditors.registerConverter(new VectorEditor());
        PropertyEditors.registerConverter(new WeakHashMapEditor());
    }
}

