/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.xbean.ClassLoading;
import org.apache.xbean.propertyeditor.PropertyEditors;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.Recipe;
import org.apache.xbean.recipe.RecipeHelper;
import org.apache.xbean.recipe.ValueRecipe;

public class ObjectRecipe
implements Recipe {
    private final String type;
    private final String factoryMethod;
    private final String[] constructorArgNames;
    private final Class[] constructorArgTypes;
    private final LinkedHashMap properties;

    public ObjectRecipe(Class type) {
        this(type.getName());
    }

    public ObjectRecipe(Class type, String factoryMethod) {
        this(type.getName(), factoryMethod);
    }

    public ObjectRecipe(Class type, Map properties) {
        this(type.getName(), properties);
    }

    public ObjectRecipe(Class type, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(type.getName(), constructorArgNames, constructorArgTypes);
    }

    public ObjectRecipe(Class type, String factoryMethod, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(type.getName(), factoryMethod, constructorArgNames, constructorArgTypes);
    }

    public ObjectRecipe(String typeName) {
        this(typeName, null, null, null, null);
    }

    public ObjectRecipe(String typeName, String factoryMethod) {
        this(typeName, factoryMethod, null, null, null);
    }

    public ObjectRecipe(String typeName, Map properties) {
        this(typeName, null, null, null, properties);
    }

    public ObjectRecipe(String typeName, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(typeName, null, constructorArgNames, constructorArgTypes, null);
    }

    public ObjectRecipe(String typeName, String factoryMethod, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(typeName, factoryMethod, constructorArgNames, constructorArgTypes, null);
    }

    public ObjectRecipe(String type, String factoryMethod, String[] constructorArgNames, Class[] constructorArgTypes, Map properties) {
        this.type = type;
        this.factoryMethod = factoryMethod;
        this.constructorArgNames = constructorArgNames != null ? constructorArgNames : new String[0];
        this.constructorArgTypes = constructorArgTypes != null ? constructorArgTypes : new Class[0];
        if (properties != null) {
            this.properties = new LinkedHashMap(properties);
            this.setAllProperties(properties);
        } else {
            this.properties = new LinkedHashMap();
        }
    }

    public Object getProperty(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        Object value = this.properties.get(name);
        return value;
    }

    public void setProperty(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (!RecipeHelper.isSimpleType(value)) {
            value = new ValueRecipe(value);
        }
        this.properties.put(name, value);
    }

    public void setAllProperties(Map map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            this.setProperty(name, value);
        }
    }

    public Object create() throws ConstructionException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return this.create(contextClassLoader);
    }

    public Object create(ClassLoader classLoader) throws ConstructionException {
        Class typeClass = null;
        try {
            typeClass = ClassLoading.loadClass(this.type, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Type class could not be found: " + this.type);
        }
        if (!Modifier.isPublic(typeClass.getModifiers())) {
            throw new ConstructionException("Class is not public: " + ClassLoading.getClassName(typeClass, true));
        }
        if (Modifier.isInterface(typeClass.getModifiers())) {
            throw new ConstructionException("Class is an interface: " + ClassLoading.getClassName(typeClass, true));
        }
        if (Modifier.isAbstract(typeClass.getModifiers())) {
            throw new ConstructionException("Class is abstract: " + ClassLoading.getClassName(typeClass, true));
        }
        LinkedHashMap propertyValues = new LinkedHashMap(this.properties);
        Iterator iterator = propertyValues.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object value = entry.getValue();
            if (!(value instanceof Recipe)) continue;
            Recipe recipe = (Recipe)value;
            value = recipe.create(classLoader);
            entry.setValue(value);
        }
        Object instance = this.createInstance(typeClass, propertyValues);
        Iterator iterator2 = propertyValues.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            String propertyName = (String)entry.getKey();
            Object propertyValue = entry.getValue();
            Method setter = ObjectRecipe.findSetter(typeClass, propertyName, propertyValue);
            try {
                propertyValue = ObjectRecipe.convert(setter.getParameterTypes()[0], propertyValue);
                setter.invoke(instance, propertyValue);
            }
            catch (Exception e) {
                throw new ConstructionException("Error setting property: " + setter);
            }
        }
        return instance;
    }

    private Object[] extractConstructorArgs(Map propertyValues, Class[] constructorArgTypes) {
        Object[] parameters = new Object[this.constructorArgNames.length];
        for (int i = 0; i < this.constructorArgNames.length; ++i) {
            Object value;
            String name = this.constructorArgNames[i];
            Class type = constructorArgTypes[i];
            if (propertyValues.containsKey(name)) {
                value = propertyValues.remove(name);
                if (!ObjectRecipe.isInstance(type, value) && !ObjectRecipe.isConvertable(type, value)) {
                    throw new ConstructionException("Invalid and non-convertable constructor parameter type: name=" + name + ", " + "index=" + i + ", " + "expected=" + ClassLoading.getClassName(type, true) + ", " + "actual=" + ClassLoading.getClassName(value, true));
                }
                value = ObjectRecipe.convert(type, value);
            } else {
                value = ObjectRecipe.getDefaultValue(type);
            }
            parameters[i] = value;
        }
        return parameters;
    }

    private static Object convert(Class type, Object value) {
        if (value instanceof String && type != Object.class) {
            String stringValue = (String)value;
            value = PropertyEditors.getValue(type, stringValue);
        }
        return value;
    }

    private static Object getDefaultValue(Class type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.FALSE;
        }
        if (type.equals(Character.TYPE)) {
            return new Character('\u0000');
        }
        if (type.equals(Byte.TYPE)) {
            return new Byte(0);
        }
        if (type.equals(Short.TYPE)) {
            return new Short(0);
        }
        if (type.equals(Integer.TYPE)) {
            return new Integer(0);
        }
        if (type.equals(Long.TYPE)) {
            return new Long(0L);
        }
        if (type.equals(Float.TYPE)) {
            return new Float(0.0f);
        }
        if (type.equals(Double.TYPE)) {
            return new Double(0.0);
        }
        return null;
    }

    private Object createInstance(Class typeClass, Map propertyValues) {
        if (this.factoryMethod != null) {
            Method method = this.selectFactory(typeClass);
            Object[] parameters = this.extractConstructorArgs(propertyValues, method.getParameterTypes());
            try {
                Object object = method.invoke(null, parameters);
                return object;
            }
            catch (Exception e) {
                InvocationTargetException invocationTargetException;
                Throwable t = e;
                if (e instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)e).getCause() != null) {
                    t = invocationTargetException.getCause();
                }
                throw new ConstructionException("Error invoking factory method: " + method, t);
            }
        }
        Constructor constructor = this.selectConstructor(typeClass);
        Object[] parameters = this.extractConstructorArgs(propertyValues, constructor.getParameterTypes());
        try {
            Object object = constructor.newInstance(parameters);
            return object;
        }
        catch (Exception e) {
            InvocationTargetException invocationTargetException;
            Throwable t = e;
            if (e instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)e).getCause() != null) {
                t = invocationTargetException.getCause();
            }
            throw new ConstructionException("Error invoking constructor: " + constructor, t);
        }
    }

    private Method selectFactory(Class typeClass) {
        if (this.constructorArgNames.length > 0 && this.constructorArgTypes.length == 0) {
            ArrayList<Method> matches = new ArrayList<Method>();
            Method[] methods = typeClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(this.factoryMethod) || method.getParameterTypes().length != this.constructorArgNames.length) continue;
                try {
                    this.checkFactory(method);
                    matches.add(method);
                    continue;
                }
                catch (Exception dontCare) {
                    // empty catch block
                }
            }
            if (matches.size() < 1) {
                StringBuffer buffer = new StringBuffer("No parameter types supplied; unable to find a potentially valid factory method: ");
                buffer.append("public static Object ").append(this.factoryMethod);
                buffer.append(this.toArgumentList(this.constructorArgNames));
                throw new ConstructionException(buffer.toString());
            }
            if (matches.size() > 1) {
                StringBuffer buffer = new StringBuffer("No parameter types supplied; found too many potentially valid factory methods: ");
                buffer.append("public static Object ").append(this.factoryMethod);
                buffer.append(this.toArgumentList(this.constructorArgNames));
                throw new ConstructionException(buffer.toString());
            }
            return (Method)matches.get(0);
        }
        try {
            Method method = typeClass.getMethod(this.factoryMethod, this.constructorArgTypes);
            this.checkFactory(method);
            return method;
        }
        catch (NoSuchMethodException e) {
            Method[] methods = typeClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(this.factoryMethod) || !ObjectRecipe.isAssignableFrom(this.constructorArgTypes, method.getParameterTypes()) || Modifier.isPublic(method.getModifiers())) continue;
                throw new ConstructionException("Factory method is not public: " + method);
            }
            StringBuffer buffer = new StringBuffer("Unable to find a valid factory method: ");
            buffer.append("public static Object ").append(ClassLoading.getClassName(typeClass, true)).append(".");
            buffer.append(this.factoryMethod).append(this.toParameterList(this.constructorArgTypes));
            throw new ConstructionException(buffer.toString());
        }
    }

    private void checkFactory(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new ConstructionException("Factory method is not public: " + method);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new ConstructionException("Factory method is not static: " + method);
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            throw new ConstructionException("Factory method does not return anything: " + method);
        }
        if (method.getReturnType().isPrimitive()) {
            throw new ConstructionException("Factory method returns a primitive type: " + method);
        }
    }

    private Constructor selectConstructor(Class typeClass) {
        if (this.constructorArgNames.length > 0 && this.constructorArgTypes.length == 0) {
            ArrayList matches = new ArrayList();
            Constructor<?>[] constructors = typeClass.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> constructor = constructors[i];
                if (constructor.getParameterTypes().length != this.constructorArgNames.length) continue;
                matches.add(constructor);
            }
            if (matches.size() < 1) {
                StringBuffer buffer = new StringBuffer("No parameter types supplied; unable to find a potentially valid constructor: ");
                buffer.append("constructor= public ").append(ClassLoading.getClassName(typeClass, true));
                buffer.append(this.toArgumentList(this.constructorArgNames));
                throw new ConstructionException(buffer.toString());
            }
            if (matches.size() > 1) {
                StringBuffer buffer = new StringBuffer("No parameter types supplied; found too many potentially valid constructors: ");
                buffer.append("constructor= public ").append(ClassLoading.getClassName(typeClass, true));
                buffer.append(this.toArgumentList(this.constructorArgNames));
                throw new ConstructionException(buffer.toString());
            }
            return (Constructor)matches.get(0);
        }
        try {
            Constructor constructor = typeClass.getConstructor(this.constructorArgTypes);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new ConstructionException("Constructor is not public: " + constructor);
            }
            return constructor;
        }
        catch (NoSuchMethodException e) {
            Constructor<?>[] constructors = typeClass.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> constructor = constructors[i];
                if (!ObjectRecipe.isAssignableFrom(this.constructorArgTypes, constructor.getParameterTypes()) || Modifier.isPublic(constructor.getModifiers())) continue;
                throw new ConstructionException("Constructor is not public: " + constructor);
            }
            StringBuffer buffer = new StringBuffer("Unable to find a valid constructor: ");
            buffer.append("constructor= public ").append(ClassLoading.getClassName(typeClass, true));
            buffer.append(this.toParameterList(this.constructorArgTypes));
            throw new ConstructionException(buffer.toString());
        }
    }

    private String toParameterList(Class[] parameterTypes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class type = parameterTypes[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(ClassLoading.getClassName(type, true));
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String toArgumentList(String[] parameterNames) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterName = parameterNames[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('<').append(parameterName).append('>');
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static Method findSetter(Class typeClass, String propertyName, Object propertyValue) {
        if (propertyName == null) {
            throw new NullPointerException("name is null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("name is an empty string");
        }
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0));
        if (propertyName.length() > 0) {
            setterName = setterName + propertyName.substring(1);
        }
        int matchLevel = 0;
        ConstructionException missException = null;
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(typeClass.getMethods()));
        methods.addAll(Arrays.asList(typeClass.getDeclaredMethods()));
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!method.getName().equals(setterName)) continue;
            if (method.getParameterTypes().length == 0) {
                if (matchLevel >= true) continue;
                matchLevel = 1;
                missException = new ConstructionException("Setter takes no parameters: " + method);
                continue;
            }
            if (method.getParameterTypes().length > 1) {
                if (matchLevel >= true) continue;
                matchLevel = 1;
                missException = new ConstructionException("Setter takes more then one parameter: " + method);
                continue;
            }
            if (method.getReturnType() != Void.TYPE) {
                if (matchLevel >= 2) continue;
                matchLevel = 2;
                missException = new ConstructionException("Setter returns a value: " + method);
                continue;
            }
            if (Modifier.isAbstract(method.getModifiers())) {
                if (matchLevel >= 3) continue;
                matchLevel = 3;
                missException = new ConstructionException("Setter is abstract: " + method);
                continue;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new ConstructionException("Setter is not public: " + method);
                continue;
            }
            if (Modifier.isStatic(method.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new ConstructionException("Setter is static: " + method);
                continue;
            }
            Class<?> methodParameterType = method.getParameterTypes()[0];
            if (methodParameterType.isPrimitive() && propertyValue == null) {
                if (matchLevel >= 6) continue;
                matchLevel = 6;
                missException = new ConstructionException("Null can not be assigned to " + ClassLoading.getClassName(methodParameterType, true) + ": " + method);
                continue;
            }
            if (!ObjectRecipe.isInstance(methodParameterType, propertyValue) && !ObjectRecipe.isConvertable(methodParameterType, propertyValue)) {
                if (matchLevel >= 5) continue;
                matchLevel = 5;
                missException = new ConstructionException(ClassLoading.getClassName(propertyValue, true) + " can not be assigned or converted to " + ClassLoading.getClassName(methodParameterType, true) + ": " + method);
                continue;
            }
            return method;
        }
        if (missException != null) {
            throw missException;
        }
        StringBuffer buffer = new StringBuffer("Unable to find a valid setter method: ");
        buffer.append("public void ").append(ClassLoading.getClassName(typeClass, true)).append(".");
        buffer.append(setterName).append("(").append(ClassLoading.getClassName(propertyValue, true)).append(")");
        throw new ConstructionException(buffer.toString());
    }

    public static boolean isConvertable(Class methodParameterType, Object propertyValue) {
        return propertyValue instanceof String && PropertyEditors.canConvert(methodParameterType);
    }

    public static boolean isInstance(Class type, Object instance) {
        if (type.isPrimitive()) {
            if (instance == null) {
                return false;
            }
            if (type.equals(Boolean.TYPE)) {
                return instance instanceof Boolean;
            }
            if (type.equals(Character.TYPE)) {
                return instance instanceof Character;
            }
            if (type.equals(Byte.TYPE)) {
                return instance instanceof Byte;
            }
            if (type.equals(Short.TYPE)) {
                return instance instanceof Short;
            }
            if (type.equals(Integer.TYPE)) {
                return instance instanceof Integer;
            }
            if (type.equals(Long.TYPE)) {
                return instance instanceof Long;
            }
            if (type.equals(Float.TYPE)) {
                return instance instanceof Float;
            }
            if (type.equals(Double.TYPE)) {
                return instance instanceof Double;
            }
            throw new AssertionError((Object)("Invalid primitve type: " + type));
        }
        return instance == null || type.isInstance(instance);
    }

    public static boolean isAssignableFrom(Class expected, Class actual) {
        if (expected.isPrimitive()) {
            if (expected.equals(Boolean.TYPE)) {
                return actual.equals(Boolean.class);
            }
            if (expected.equals(Character.TYPE)) {
                return actual.equals(Character.class);
            }
            if (expected.equals(Byte.TYPE)) {
                return actual.equals(Byte.class);
            }
            if (expected.equals(Short.TYPE)) {
                return actual.equals(Short.class);
            }
            if (expected.equals(Integer.TYPE)) {
                return actual.equals(Integer.class);
            }
            if (expected.equals(Long.TYPE)) {
                return actual.equals(Long.class);
            }
            if (expected.equals(Float.TYPE)) {
                return actual.equals(Float.class);
            }
            if (expected.equals(Double.TYPE)) {
                return actual.equals(Double.class);
            }
            throw new AssertionError((Object)("Invalid primitve type: " + expected));
        }
        return expected.isAssignableFrom(actual);
    }

    public static boolean isAssignableFrom(Class[] expectedTypes, Class[] actualTypes) {
        if (expectedTypes.length != actualTypes.length) {
            return false;
        }
        for (int i = 0; i < expectedTypes.length; ++i) {
            Class expectedType = expectedTypes[i];
            Class actualType = actualTypes[i];
            if (ObjectRecipe.isAssignableFrom(expectedType, actualType)) continue;
            return false;
        }
        return true;
    }
}

