/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.xbean.ClassLoading;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.Recipe;
import org.apache.xbean.recipe.RecipeHelper;
import org.apache.xbean.recipe.ValueRecipe;

public class MapRecipe
implements Recipe {
    private final List entries;
    private final String type;

    public MapRecipe() {
        this.type = LinkedHashMap.class.getName();
        this.entries = new ArrayList();
    }

    public MapRecipe(String type) {
        this.type = type;
        this.entries = new ArrayList();
    }

    public MapRecipe(Class type) {
        this.type = type.getName();
        if (!RecipeHelper.hasDefaultConstructor(type)) {
            throw new IllegalArgumentException("Type does not have a default constructor " + type);
        }
        this.entries = new ArrayList();
    }

    public MapRecipe(Map map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        this.entries = new ArrayList(map.size());
        this.type = RecipeHelper.hasDefaultConstructor(map.getClass()) ? map.getClass().getName() : (map instanceof SortedMap ? TreeMap.class.getName() : LinkedHashMap.class.getName());
        this.putAll(map);
    }

    public MapRecipe(String type, Map map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        this.type = type;
        this.entries = new ArrayList(map.size());
        this.putAll(map);
    }

    public MapRecipe(Class type, Map map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        if (!RecipeHelper.hasDefaultConstructor(type)) {
            throw new IllegalArgumentException("Type does not have a default constructor " + type);
        }
        this.type = type.getName();
        this.entries = new ArrayList(map.size());
        this.putAll(map);
    }

    public MapRecipe(MapRecipe mapRecipe) {
        if (mapRecipe == null) {
            throw new NullPointerException("mapRecipe is null");
        }
        this.type = mapRecipe.type;
        this.entries = new ArrayList(mapRecipe.entries);
    }

    public Object create(ClassLoader classLoader) {
        Object o;
        Class mapType = null;
        try {
            mapType = ClassLoading.loadClass(this.type, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Type class could not be found: " + this.type);
        }
        if (!RecipeHelper.hasDefaultConstructor(mapType)) {
            throw new ConstructionException("Type does not have a default constructor " + this.type);
        }
        try {
            o = mapType.newInstance();
        }
        catch (Exception e) {
            throw new ConstructionException("Error while creating set instance: " + this.type);
        }
        if (!(o instanceof Map)) {
            throw new ConstructionException("Specified map type does not implement the Map interface: " + this.type);
        }
        Map instance = (Map)o;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Object value;
            Object[] entry = (Object[])iterator.next();
            Object key = entry[0];
            if (key instanceof Recipe) {
                Recipe recipe = (Recipe)key;
                try {
                    key = recipe.create(classLoader);
                }
                catch (ConstructionException e) {
                    e.setPrependAttributeName("[" + this.type + " " + key + "]");
                    throw e;
                }
            }
            if ((value = entry[1]) instanceof Recipe) {
                Recipe recipe = (Recipe)value;
                try {
                    value = recipe.create(classLoader);
                }
                catch (ConstructionException e) {
                    e.setPrependAttributeName("[" + this.type + " " + key + "]");
                    throw e;
                }
            }
            instance.put(key, value);
        }
        return instance;
    }

    public void put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (!RecipeHelper.isSimpleType(key)) {
            key = new ValueRecipe(key);
        }
        if (!RecipeHelper.isSimpleType(value)) {
            value = new ValueRecipe(value);
        }
        this.entries.add(new Object[]{key, value});
    }

    public void putAll(Map map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.put(key, value);
        }
    }
}

