/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.classloader;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.xbean.classloader.NamedClassLoader;

public class MultiParentClassLoader
extends NamedClassLoader {
    private final ClassLoader[] parents;
    private final boolean inverseClassLoading;
    private final String[] hiddenClasses;
    private final String[] nonOverridableClasses;
    private final String[] hiddenResources;
    private final String[] nonOverridableResources;
    private final Map<String, SoftReference<Class>> cache = new ConcurrentHashMap<String, SoftReference<Class>>();

    public MultiParentClassLoader(String name, URL[] urls) {
        this(name, urls, ClassLoader.getSystemClassLoader());
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader parent) {
        this(name, urls, new ClassLoader[]{parent});
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this(name, urls, new ClassLoader[]{parent}, factory);
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader[] parents) {
        this(name, urls, parents, false, new String[0], new String[0]);
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader parent, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        this(name, urls, new ClassLoader[]{parent}, inverseClassLoading, hiddenClasses, nonOverridableClasses);
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader[] parents, URLStreamHandlerFactory factory) {
        super(name, urls, null, factory);
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.inverseClassLoading = false;
        this.hiddenClasses = new String[0];
        this.nonOverridableClasses = new String[0];
        this.hiddenResources = new String[0];
        this.nonOverridableResources = new String[0];
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader[] parents, boolean inverseClassLoading, Collection hiddenClasses, Collection nonOverridableClasses) {
        this(name, urls, parents, inverseClassLoading, hiddenClasses.toArray(new String[hiddenClasses.size()]), nonOverridableClasses.toArray(new String[nonOverridableClasses.size()]));
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader[] parents, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        super(name, urls);
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.inverseClassLoading = inverseClassLoading;
        this.hiddenClasses = hiddenClasses;
        this.nonOverridableClasses = nonOverridableClasses;
        this.hiddenResources = MultiParentClassLoader.toResources(hiddenClasses);
        this.nonOverridableResources = MultiParentClassLoader.toResources(nonOverridableClasses);
    }

    private static String[] toResources(String[] classes) {
        String[] resources = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            String className = classes[i];
            resources[i] = className.replace('.', '/');
        }
        return resources;
    }

    private static ClassLoader[] copyParents(ClassLoader[] parents) {
        ClassLoader[] newParentsArray = new ClassLoader[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            ClassLoader parent = parents[i];
            if (parent == null) {
                throw new NullPointerException("parent[" + i + "] is null");
            }
            newParentsArray[i] = parent;
        }
        return newParentsArray;
    }

    public ClassLoader[] getParents() {
        return this.parents;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class result = null;
        SoftReference<Class> reference = this.cache.get(name);
        if (reference != null) {
            result = reference.get();
        }
        if (result == null) {
            result = this.doLoadClass(name, resolve);
            this.cache.put(name, new SoftReference<Class>(result));
        }
        return result;
    }

    private synchronized Class doLoadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cachedClass = this.findLoadedClass(name);
        if (cachedClass != null) {
            return this.resolveClass(cachedClass, resolve);
        }
        if (this.inverseClassLoading && !this.isDestroyed() && !this.isNonOverridableClass(name)) {
            try {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            catch (ClassNotFoundException clazz) {
                // empty catch block
            }
        }
        if (!this.isHiddenClass(name)) {
            for (int i = 0; i < this.parents.length; ++i) {
                ClassLoader parent = this.parents[i];
                try {
                    Class<?> clazz = parent.loadClass(name);
                    return this.resolveClass(clazz, resolve);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
            }
        }
        if (!this.isDestroyed()) {
            try {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name + " in classloader " + this.getName());
    }

    private boolean isNonOverridableClass(String name) {
        for (int i = 0; i < this.nonOverridableClasses.length; ++i) {
            if (!name.startsWith(this.nonOverridableClasses[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isHiddenClass(String name) {
        for (int i = 0; i < this.hiddenClasses.length; ++i) {
            if (!name.startsWith(this.hiddenClasses[i])) continue;
            return true;
        }
        return false;
    }

    private Class resolveClass(Class clazz, boolean resolve) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL url;
        if (this.isDestroyed()) {
            return null;
        }
        if (this.inverseClassLoading && !this.isDestroyed() && !this.isNonOverridableResource(name) && (url = this.findResource(name)) != null) {
            return url;
        }
        if (!this.isHiddenResource(name)) {
            for (int i = 0; i < this.parents.length; ++i) {
                ClassLoader parent = this.parents[i];
                URL url2 = parent.getResource(name);
                if (url2 == null) continue;
                return url2;
            }
        }
        if (!this.isDestroyed()) {
            return this.findResource(name);
        }
        return null;
    }

    public Enumeration findResources(String name) throws IOException {
        if (this.isDestroyed()) {
            return Collections.enumeration(Collections.EMPTY_SET);
        }
        ArrayList<URL> resources = new ArrayList<URL>();
        if (this.inverseClassLoading && !this.isDestroyed()) {
            ArrayList<URL> myResources = Collections.list(super.findResources(name));
            resources.addAll(myResources);
        }
        for (int i = 0; i < this.parents.length; ++i) {
            ClassLoader parent = this.parents[i];
            ArrayList<URL> parentResources = Collections.list(parent.getResources(name));
            resources.addAll(parentResources);
        }
        if (!this.inverseClassLoading && !this.isDestroyed()) {
            ArrayList<URL> myResources = Collections.list(super.findResources(name));
            resources.addAll(myResources);
        }
        return Collections.enumeration(resources);
    }

    private boolean isNonOverridableResource(String name) {
        for (int i = 0; i < this.nonOverridableResources.length; ++i) {
            if (!name.startsWith(this.nonOverridableResources[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isHiddenResource(String name) {
        for (int i = 0; i < this.hiddenResources.length; ++i) {
            if (!name.startsWith(this.hiddenResources[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getName() + ": name=" + this.getName() + " urls=" + Arrays.asList(this.getURLs()) + " parents=" + Arrays.asList(this.parents) + "]";
    }
}

