/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.xbean.osgi.bundle.util.BundleDescription;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xbean.osgi.bundle.util.DiscoveryRange;
import org.apache.xbean.osgi.bundle.util.ResourceDiscoveryFilter;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleResourceFinder {
    public static final ResourceDiscoveryFilter FULL_DISCOVERY_FILTER = new DummyDiscoveryFilter();
    private final Bundle bundle;
    private final PackageAdmin packageAdmin;
    private final String prefix;
    private final String suffix;
    private final String osgiSuffix;
    private final boolean extendedMatching;
    private ResourceDiscoveryFilter discoveryFilter;

    public BundleResourceFinder(PackageAdmin packageAdmin, Bundle bundle, String prefix, String suffix) {
        this(packageAdmin, bundle, prefix, suffix, FULL_DISCOVERY_FILTER);
    }

    public BundleResourceFinder(PackageAdmin packageAdmin, Bundle bundle, String prefix, String suffix, ResourceDiscoveryFilter discoveryFilter) {
        this.packageAdmin = packageAdmin;
        this.bundle = BundleUtils.unwrapBundle(bundle);
        this.prefix = BundleResourceFinder.addSlash(prefix.trim());
        this.suffix = suffix.trim();
        int pos = this.suffix.lastIndexOf("/");
        if (pos > -1) {
            this.osgiSuffix = this.suffix.substring(pos + 1, this.suffix.length());
            this.extendedMatching = true;
        } else {
            this.osgiSuffix = "*" + this.suffix;
            this.extendedMatching = false;
        }
        this.discoveryFilter = discoveryFilter;
    }

    public void find(ResourceFinderCallback callback) throws Exception {
        Bundle[] fragments;
        if (this.discoveryFilter.rangeDiscoveryRequired(DiscoveryRange.BUNDLE_CLASSPATH) && !this.scanBundleClassPath(callback, this.bundle)) {
            return;
        }
        if (this.packageAdmin != null && this.discoveryFilter.rangeDiscoveryRequired(DiscoveryRange.FRAGMENT_BUNDLES) && (fragments = this.packageAdmin.getFragments(this.bundle)) != null) {
            for (Bundle fragment : fragments) {
                if (this.scanBundleClassPath(callback, fragment)) continue;
                return;
            }
        }
    }

    public Set<URL> find() {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        try {
            this.find(new DefaultResourceFinderCallback(resources));
        }
        catch (Exception e) {
            throw new RuntimeException("Resource discovery failed", e);
        }
        return resources;
    }

    private boolean scanBundleClassPath(ResourceFinderCallback callback, Bundle bundle) throws Exception {
        BundleDescription desc = new BundleDescription(bundle.getHeaders());
        List<BundleDescription.HeaderEntry> paths = desc.getBundleClassPath();
        boolean continueScanning = true;
        if (paths.isEmpty()) {
            continueScanning = this.scanDirectory(callback, bundle, this.prefix);
        } else {
            BundleDescription.HeaderEntry path;
            String name;
            Iterator<BundleDescription.HeaderEntry> i$ = paths.iterator();
            while (i$.hasNext() && (continueScanning = (name = (path = i$.next()).getName()).equals(".") || name.equals("/") ? this.scanDirectory(callback, bundle, this.prefix) : (name.endsWith(".jar") || name.endsWith(".zip") ? this.scanZip(callback, bundle, name) : this.scanDirectory(callback, bundle, this.prefix.startsWith("/") ? name + this.prefix : name + "/" + this.prefix)))) {
            }
        }
        return continueScanning;
    }

    private boolean scanDirectory(ResourceFinderCallback callback, Bundle bundle, String basePath) throws Exception {
        if (!this.discoveryFilter.directoryDiscoveryRequired(basePath)) {
            return true;
        }
        Enumeration e = bundle.findEntries(basePath, this.osgiSuffix, true);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL url = (URL)e.nextElement();
                if (this.extendedMatching && !this.suffixMatches(url.getPath()) || callback.foundInDirectory(bundle, basePath, url)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean scanZip(ResourceFinderCallback callback, Bundle bundle, String zipName) throws Exception {
        if (!this.discoveryFilter.zipFileDiscoveryRequired(zipName)) {
            return true;
        }
        URL zipEntry = bundle.getEntry(zipName);
        if (zipEntry == null) {
            return true;
        }
        try {
            ZipEntry entry;
            ZipInputStream in = new ZipInputStream(zipEntry.openStream());
            while ((entry = in.getNextEntry()) != null) {
                String name = entry.getName();
                if (!this.prefixMatches(name) || !this.suffixMatches(name) || callback.foundInJar(bundle, zipName, entry, new ZipEntryInputStream(in))) continue;
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean prefixMatches(String name) {
        if (this.prefix.length() == 0 || this.prefix.equals(".") || this.prefix.equals("/")) {
            return true;
        }
        if (this.prefix.startsWith("/")) {
            return name.startsWith(this.prefix, 1);
        }
        return name.startsWith(this.prefix);
    }

    private boolean suffixMatches(String name) {
        return this.suffix.length() == 0 ? true : name.endsWith(this.suffix);
    }

    private static String addSlash(String name) {
        if (name == null) {
            return "";
        }
        if (!(name = name.trim()).isEmpty() && !name.endsWith("/")) {
            name = name + "/";
        }
        return name;
    }

    public static class DummyDiscoveryFilter
    implements ResourceDiscoveryFilter {
        public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
            return true;
        }

        public boolean directoryDiscoveryRequired(String url) {
            return true;
        }

        public boolean zipFileDiscoveryRequired(String url) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultResourceFinderCallback
    implements ResourceFinderCallback {
        private Set<URL> resources;

        public DefaultResourceFinderCallback() {
            this(new LinkedHashSet<URL>());
        }

        public DefaultResourceFinderCallback(Set<URL> resources) {
            this.resources = resources;
        }

        public Set<URL> getResources() {
            return this.resources;
        }

        @Override
        public boolean foundInDirectory(Bundle bundle, String baseDir, URL url) throws Exception {
            this.resources.add(url);
            return true;
        }

        @Override
        public boolean foundInJar(Bundle bundle, String jarName, ZipEntry entry, InputStream in) throws Exception {
            URL jarURL = bundle.getEntry(jarName);
            URL url = new URL("jar:" + jarURL.toString() + "!/" + entry.getName());
            this.resources.add(url);
            return true;
        }
    }

    public static interface ResourceFinderCallback {
        public boolean foundInDirectory(Bundle var1, String var2, URL var3) throws Exception;

        public boolean foundInJar(Bundle var1, String var2, ZipEntry var3, InputStream var4) throws Exception;
    }

    private static class ZipEntryInputStream
    extends FilterInputStream {
        public ZipEntryInputStream(ZipInputStream in) {
            super(in);
        }

        public void close() throws IOException {
        }
    }
}

