/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.docpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.docpath.XmlSchemaStateMachineNode;
import org.apache.ws.commons.schema.walker.XmlSchemaAttrInfo;
import org.apache.ws.commons.schema.walker.XmlSchemaTypeInfo;
import org.apache.ws.commons.schema.walker.XmlSchemaVisitor;

public final class XmlSchemaStateMachineGenerator
implements XmlSchemaVisitor {
    private List<XmlSchemaStateMachineNode> stack = new ArrayList<XmlSchemaStateMachineNode>();
    private XmlSchemaStateMachineNode startNode = null;
    private Map<QName, ElementInfo> elementInfoByQName = new HashMap<QName, ElementInfo>();

    public XmlSchemaStateMachineNode getStartNode() {
        return this.startNode;
    }

    public Map<QName, XmlSchemaStateMachineNode> getStateMachineNodesByQName() {
        HashMap<QName, XmlSchemaStateMachineNode> nodes = new HashMap<QName, XmlSchemaStateMachineNode>();
        for (Map.Entry<QName, ElementInfo> entry : this.elementInfoByQName.entrySet()) {
            nodes.put(entry.getKey(), entry.getValue().stateMachineNode);
        }
        return nodes;
    }

    @Override
    public void onEnterElement(XmlSchemaElement element, XmlSchemaTypeInfo typeInfo, boolean previouslyVisited) {
        if (!previouslyVisited) {
            ElementInfo info = new ElementInfo(element, typeInfo);
            this.elementInfoByQName.put(element.getQName(), info);
        } else {
            ElementInfo elemInfo = this.elementInfoByQName.get(element.getQName());
            if (elemInfo == null || elemInfo.stateMachineNode == null) {
                throw new IllegalStateException("Element " + element.getQName() + " was already visited, but we do not have a state machine for it.");
            }
            if (this.stack.isEmpty()) {
                throw new IllegalStateException("Element " + element.getQName() + " was previously visited, but there is no parent state machine node to attach it to!");
            }
            XmlSchemaStateMachineNode stateMachineNode = elemInfo.stateMachineNode;
            if (stateMachineNode.getMinOccurs() != element.getMinOccurs() || stateMachineNode.getMaxOccurs() != element.getMaxOccurs()) {
                stateMachineNode = new XmlSchemaStateMachineNode(element, elemInfo.attributes, elemInfo.typeInfo);
            }
            this.stack.get(this.stack.size() - 1).addPossibleNextState(stateMachineNode);
            this.stack.add(stateMachineNode);
        }
    }

    @Override
    public void onExitElement(XmlSchemaElement element, XmlSchemaTypeInfo typeInfo, boolean previouslyVisited) {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Exiting " + element.getQName() + ", but the stack is empty.");
        }
        XmlSchemaStateMachineNode node = this.stack.remove(this.stack.size() - 1);
        if (!node.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT)) {
            throw new IllegalStateException("Exiting element " + element.getQName() + ", but  " + node + " is on the stack.");
        }
        if (!node.getElement().getQName().equals(element.getQName())) {
            throw new IllegalStateException("Element " + element.getQName() + " is not the same in-memory copy we received on creation.  Our copy is of a " + node.getElement().getQName());
        }
    }

    @Override
    public void onVisitAttribute(XmlSchemaElement element, XmlSchemaAttrInfo attrInfo) {
        ElementInfo elemInfo = this.elementInfoByQName.get(element.getQName());
        if (elemInfo == null) {
            throw new IllegalStateException("No record exists for element " + element.getQName());
        }
        elemInfo.addAttribute(attrInfo);
    }

    @Override
    public void onEndAttributes(XmlSchemaElement element, XmlSchemaTypeInfo elemTypeInfo) {
        ElementInfo elemInfo = this.elementInfoByQName.get(element.getQName());
        if (elemInfo.stateMachineNode != null) {
            throw new IllegalStateException("Parent element " + element.getQName() + " is supposedly undefined, but that entry already has a state machine of " + elemInfo.stateMachineNode);
        }
        elemInfo.stateMachineNode = new XmlSchemaStateMachineNode(elemInfo.element, elemInfo.attributes, elemInfo.typeInfo);
        if (!this.stack.isEmpty()) {
            this.stack.get(this.stack.size() - 1).addPossibleNextState(elemInfo.stateMachineNode);
        } else {
            this.startNode = elemInfo.stateMachineNode;
        }
        this.stack.add(elemInfo.stateMachineNode);
    }

    @Override
    public void onEnterSubstitutionGroup(XmlSchemaElement base) {
        if (this.stack.isEmpty()) {
            this.startNode = new XmlSchemaStateMachineNode(XmlSchemaStateMachineNode.Type.SUBSTITUTION_GROUP, base.getMinOccurs(), base.getMaxOccurs());
            this.stack.add(this.startNode);
        } else {
            this.pushGroup(XmlSchemaStateMachineNode.Type.SUBSTITUTION_GROUP, base.getMinOccurs(), base.getMaxOccurs());
        }
    }

    @Override
    public void onExitSubstitutionGroup(XmlSchemaElement base) {
        this.popGroup(XmlSchemaStateMachineNode.Type.SUBSTITUTION_GROUP);
    }

    @Override
    public void onEnterAllGroup(XmlSchemaAll all) {
        this.pushGroup(XmlSchemaStateMachineNode.Type.ALL, all.getMinOccurs(), all.getMaxOccurs());
    }

    @Override
    public void onExitAllGroup(XmlSchemaAll all) {
        this.popGroup(XmlSchemaStateMachineNode.Type.ALL);
    }

    @Override
    public void onEnterChoiceGroup(XmlSchemaChoice choice) {
        this.pushGroup(XmlSchemaStateMachineNode.Type.CHOICE, choice.getMinOccurs(), choice.getMaxOccurs());
    }

    @Override
    public void onExitChoiceGroup(XmlSchemaChoice choice) {
        this.popGroup(XmlSchemaStateMachineNode.Type.CHOICE);
    }

    @Override
    public void onEnterSequenceGroup(XmlSchemaSequence seq) {
        this.pushGroup(XmlSchemaStateMachineNode.Type.SEQUENCE, seq.getMinOccurs(), seq.getMaxOccurs());
    }

    @Override
    public void onExitSequenceGroup(XmlSchemaSequence seq) {
        this.popGroup(XmlSchemaStateMachineNode.Type.SEQUENCE);
    }

    @Override
    public void onVisitAny(XmlSchemaAny any) {
        XmlSchemaStateMachineNode node = new XmlSchemaStateMachineNode(any);
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Reached an wildcard with no parent!  The stack is empty.");
        }
        this.stack.get(this.stack.size() - 1).addPossibleNextState(node);
    }

    @Override
    public void onVisitAnyAttribute(XmlSchemaElement element, XmlSchemaAnyAttribute anyAttr) {
    }

    private void pushGroup(XmlSchemaStateMachineNode.Type groupType, long minOccurs, long maxOccurs) {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Attempted to create a(n) " + (Object)((Object)groupType) + " group with no parent - the stack is empty!");
        }
        XmlSchemaStateMachineNode node = new XmlSchemaStateMachineNode(groupType, minOccurs, maxOccurs);
        this.stack.get(this.stack.size() - 1).addPossibleNextState(node);
        this.stack.add(node);
    }

    private void popGroup(XmlSchemaStateMachineNode.Type groupType) {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Exiting an " + (Object)((Object)groupType) + " group, but the stack is empty!");
        }
        XmlSchemaStateMachineNode node = this.stack.remove(this.stack.size() - 1);
        if (!node.getNodeType().equals((Object)groupType)) {
            throw new IllegalStateException("Attempted to pop a " + (Object)((Object)groupType) + " off of the stack, but found a " + (Object)((Object)node.getNodeType()) + " instead!");
        }
        if (!groupType.equals((Object)XmlSchemaStateMachineNode.Type.SUBSTITUTION_GROUP) && this.stack.isEmpty()) {
            throw new IllegalStateException("Popped a group of type " + (Object)((Object)groupType) + " only to find it did not have a parent.");
        }
    }

    private static class ElementInfo {
        final List<XmlSchemaAttrInfo> attributes;
        final XmlSchemaTypeInfo typeInfo;
        final XmlSchemaElement element;
        XmlSchemaStateMachineNode stateMachineNode;

        ElementInfo(XmlSchemaElement element, XmlSchemaTypeInfo typeInfo) {
            this.element = element;
            this.typeInfo = typeInfo;
            this.attributes = new ArrayList<XmlSchemaAttrInfo>();
            this.stateMachineNode = null;
        }

        void addAttribute(XmlSchemaAttrInfo attrInfo) {
            this.attributes.add(attrInfo);
        }
    }
}

