/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.stax;

import com.google.common.truth.Truth;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.testutils.stax.AttributeSortingXMLStreamReaderFilter;
import org.apache.axiom.testutils.stax.InvocationResults;
import org.apache.axiom.testutils.stax.Normalizer;
import org.apache.axiom.testutils.stax.SpaceAsCharactersXMLStreamReaderFilter;
import org.junit.Assert;

public class XMLStreamReaderComparator {
    private XMLStreamReader expected;
    private XMLStreamReader actual;
    private boolean compareInternalSubset = true;
    private boolean compareEntityReplacementValue = true;
    private boolean compareCharacterEncodingScheme = true;
    private boolean compareEncoding = true;
    private boolean sortAttributes = false;
    private boolean treatSpaceAsCharacters = false;
    private final LinkedList<QName> path = new LinkedList();
    private final Set<String> prefixes = new HashSet<String>();
    private final Set<String> namespaceURIs = new HashSet<String>();

    public XMLStreamReaderComparator(XMLStreamReader expected, XMLStreamReader actual) {
        this.expected = expected;
        this.actual = actual;
    }

    private String getLocation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("event type ");
        buffer.append(this.expected.getEventType());
        buffer.append("; location ");
        for (QName qname : this.path) {
            buffer.append('/');
            buffer.append(qname);
        }
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> InvocationResults<T> invoke(Class<T> returnType, String methodName, Class<?>[] paramTypes, Object[] args) throws Exception {
        Throwable actualException;
        Object actualResult;
        Throwable expectedException;
        Object expectedResult;
        Method method = XMLStreamReader.class.getMethod(methodName, paramTypes);
        try {
            expectedResult = returnType.cast(method.invoke((Object)this.expected, args));
            expectedException = null;
        }
        catch (InvocationTargetException ex) {
            expectedResult = null;
            expectedException = ex.getCause();
        }
        try {
            actualResult = returnType.cast(method.invoke((Object)this.actual, args));
            actualException = null;
        }
        catch (InvocationTargetException ex) {
            actualResult = null;
            actualException = ex.getCause();
        }
        if (expectedException == null) {
            if (actualException == null) return new InvocationResults<Object>(expectedResult, actualResult);
            actualException.printStackTrace(System.out);
            Assert.fail((String)("Method " + methodName + " threw unexpected exception " + actualException.getClass().getName() + " (" + this.getLocation() + ")"));
            return null;
        } else if (actualException == null) {
            Assert.fail((String)("Expected " + methodName + " to throw " + expectedException.getClass().getName() + ", but the method returned normally (" + this.getLocation() + ")"));
            return null;
        } else {
            Assert.assertEquals((String)("Unexpected exception thrown by " + methodName), expectedException.getClass(), actualException.getClass());
        }
        return null;
    }

    private <T> InvocationResults<T> invoke(Class<T> returnType, String methodName) throws Exception {
        return this.invoke(returnType, methodName, new Class[0], new Object[0]);
    }

    private <T> T assertSameResult(Class<T> returnType, String methodName, Class<?>[] paramTypes, Object[] args, Normalizer<T> normalizer) throws Exception {
        InvocationResults<T> results = this.invoke(returnType, methodName, paramTypes, args);
        if (results != null) {
            T expected = normalizer == null ? results.getExpected() : normalizer.normalize(results.getExpected());
            T actual = normalizer == null ? results.getActual() : normalizer.normalize(results.getActual());
            Assert.assertEquals((String)("Return value of " + methodName + " for arguments " + Arrays.asList(args) + " (" + this.getLocation() + ")"), expected, actual);
            return results.getExpected();
        }
        return null;
    }

    private <T> T assertSameResult(Class<T> returnType, String methodName, Class<?>[] paramTypes, Object[] args) throws Exception {
        return this.assertSameResult(returnType, methodName, paramTypes, args, null);
    }

    private <T> T assertSameResult(Class<T> returnType, String methodName, Normalizer<T> normalizer) throws Exception {
        return this.assertSameResult(returnType, methodName, new Class[0], new Object[0], normalizer);
    }

    private <T> T assertSameResult(Class<T> returnType, String methodName) throws Exception {
        return this.assertSameResult(returnType, methodName, null);
    }

    private Set<String> toPrefixSet(Iterator<?> it) {
        HashSet<String> set = new HashSet<String>();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            set.add(prefix == null ? "" : prefix);
        }
        return set;
    }

    private void compareNamespaceContexts(NamespaceContext expected, NamespaceContext actual) {
        for (String prefix : this.prefixes) {
            if (prefix == null) continue;
            Assert.assertEquals((String)("Namespace URI for prefix '" + prefix + "' (" + this.getLocation() + ")"), (Object)expected.getNamespaceURI(prefix), (Object)actual.getNamespaceURI(prefix));
        }
        for (String namespaceURI : this.namespaceURIs) {
            if (namespaceURI == null || namespaceURI.length() <= 0) continue;
            Set<String> prefixes = this.toPrefixSet(expected.getPrefixes(namespaceURI));
            Assert.assertEquals((String)("Prefixes for namespace URI '" + namespaceURI + "' (" + this.getLocation() + ")"), prefixes, this.toPrefixSet(actual.getPrefixes(namespaceURI)));
            if (prefixes.size() <= 1) {
                Assert.assertEquals((String)("Prefix for namespace URI '" + namespaceURI + "' (" + this.getLocation() + ")"), (Object)expected.getPrefix(namespaceURI), (Object)actual.getPrefix(namespaceURI));
                continue;
            }
            Truth.assertThat((String)actual.getPrefix(namespaceURI)).isIn(prefixes);
        }
    }

    public void addPrefix(String prefix) {
        this.prefixes.add(prefix);
    }

    public void setCompareInternalSubset(boolean compareInternalSubset) {
        this.compareInternalSubset = compareInternalSubset;
    }

    public void setCompareEntityReplacementValue(boolean value) {
        this.compareEntityReplacementValue = value;
    }

    public void setCompareCharacterEncodingScheme(boolean value) {
        this.compareCharacterEncodingScheme = value;
    }

    public void setCompareEncoding(boolean value) {
        this.compareEncoding = value;
    }

    public void setSortAttributes(boolean sortAttributes) {
        this.sortAttributes = sortAttributes;
    }

    public void setTreatSpaceAsCharacters(boolean treatSpaceAsCharacters) {
        this.treatSpaceAsCharacters = treatSpaceAsCharacters;
    }

    public void compare() throws Exception {
        if (this.sortAttributes) {
            this.expected = new AttributeSortingXMLStreamReaderFilter(this.expected);
            this.actual = new AttributeSortingXMLStreamReaderFilter(this.actual);
        }
        if (this.treatSpaceAsCharacters) {
            this.expected = new SpaceAsCharactersXMLStreamReaderFilter(this.expected);
            this.actual = new SpaceAsCharactersXMLStreamReaderFilter(this.actual);
        }
        while (true) {
            int expectedNextEvent;
            int i;
            int eventType;
            if ((eventType = this.assertSameResult(Integer.class, "getEventType").intValue()) == 1) {
                this.path.addLast(this.expected.getName());
            }
            if (this.compareCharacterEncodingScheme) {
                this.assertSameResult(String.class, "getCharacterEncodingScheme");
            }
            if (this.compareEncoding) {
                this.assertSameResult(String.class, "getEncoding", Normalizer.LOWER_CASE);
            }
            Integer attributeCount = this.assertSameResult(Integer.class, "getAttributeCount");
            for (i = 0; i < (attributeCount == null ? 1 : attributeCount); ++i) {
                Class[] paramTypes = new Class[]{Integer.TYPE};
                Object[] args = new Object[]{new Integer(i)};
                this.assertSameResult(String.class, "getAttributeLocalName", paramTypes, args);
                this.assertSameResult(QName.class, "getAttributeName", paramTypes, args);
                this.namespaceURIs.add(this.assertSameResult(String.class, "getAttributeNamespace", paramTypes, args));
                this.prefixes.add(this.assertSameResult(String.class, "getAttributePrefix", paramTypes, args, Normalizer.EMPTY_STRING_TO_NULL));
                this.assertSameResult(String.class, "getAttributeType", paramTypes, args);
                this.assertSameResult(String.class, "getAttributeValue", paramTypes, args);
                this.assertSameResult(Boolean.class, "isAttributeSpecified", paramTypes, args);
            }
            if (attributeCount != null) {
                for (i = 0; i < attributeCount; ++i) {
                    QName qname = this.expected.getAttributeName(i);
                    this.assertSameResult(String.class, "getAttributeValue", new Class[]{String.class, String.class}, new Object[]{qname.getNamespaceURI(), qname.getLocalPart()});
                }
            }
            this.assertSameResult(String.class, "getLocalName");
            this.assertSameResult(QName.class, "getName");
            Integer namespaceCount = this.assertSameResult(Integer.class, "getNamespaceCount");
            if (namespaceCount != null) {
                HashMap<String, String> expectedNamespaces = new HashMap<String, String>();
                HashMap<String, String> actualNamespaces = new HashMap<String, String>();
                for (int i2 = 0; i2 < namespaceCount; ++i2) {
                    String expectedPrefix = this.expected.getNamespacePrefix(i2);
                    String expectedNamespaceURI = this.expected.getNamespaceURI(i2);
                    if (expectedNamespaceURI != null && expectedNamespaceURI.length() == 0) {
                        expectedNamespaceURI = null;
                    }
                    String actualPrefix = this.actual.getNamespacePrefix(i2);
                    String actualNamespaceURI = this.actual.getNamespaceURI(i2);
                    if (actualNamespaceURI != null && actualNamespaceURI.length() == 0) {
                        actualNamespaceURI = null;
                    }
                    expectedNamespaces.put(expectedPrefix, expectedNamespaceURI);
                    actualNamespaces.put(actualPrefix, actualNamespaceURI);
                    this.prefixes.add(expectedPrefix);
                    this.namespaceURIs.add(expectedNamespaceURI);
                }
                Assert.assertEquals(expectedNamespaces, actualNamespaces);
            }
            this.namespaceURIs.add(this.assertSameResult(String.class, "getNamespaceURI"));
            this.assertSameResult(String.class, "getPIData");
            this.assertSameResult(String.class, "getPITarget");
            this.prefixes.add(this.assertSameResult(String.class, "getPrefix"));
            if ((eventType != 11 || this.compareInternalSubset) && (eventType != 9 || this.compareEntityReplacementValue)) {
                this.assertSameResult(String.class, "getText", eventType == 11 ? Normalizer.DTD : null);
            }
            Integer textLength = this.assertSameResult(Integer.class, "getTextLength");
            InvocationResults<Integer> textStart = this.invoke(Integer.class, "getTextStart");
            InvocationResults<char[]> textCharacters = this.invoke(char[].class, "getTextCharacters");
            if (textLength != null) {
                Assert.assertEquals((Object)new String(textCharacters.getExpected(), (int)textStart.getExpected(), (int)textLength), (Object)new String(textCharacters.getActual(), (int)textStart.getActual(), (int)textLength));
            }
            this.assertSameResult(Boolean.class, "hasName");
            this.assertSameResult(Boolean.class, "hasText");
            this.assertSameResult(Boolean.class, "isCharacters");
            this.assertSameResult(Boolean.class, "isEndElement");
            this.assertSameResult(Boolean.class, "isStartElement");
            this.assertSameResult(Boolean.class, "isWhiteSpace");
            if (eventType == 1 || eventType == 2) {
                for (String prefix : this.prefixes) {
                    if (prefix == null || prefix.equals("xml")) continue;
                    this.assertSameResult(String.class, "getNamespaceURI", new Class[]{String.class}, new Object[]{prefix});
                }
            }
            this.compareNamespaceContexts(this.expected.getNamespaceContext(), this.actual.getNamespaceContext());
            if (eventType == 2) {
                this.path.removeLast();
            }
            this.assertSameResult(Boolean.class, "hasNext");
            try {
                expectedNextEvent = this.expected.next();
            }
            catch (IllegalStateException ex) {
                expectedNextEvent = -1;
            }
            catch (NoSuchElementException ex) {
                expectedNextEvent = -1;
            }
            if (expectedNextEvent == -1) {
                try {
                    this.actual.next();
                }
                catch (IllegalStateException ex) {
                    break;
                }
                catch (NoSuchElementException ex) {
                    break;
                }
                Assert.fail((String)"Expected reader to throw IllegalStateException or NoSuchElementException");
                continue;
            }
            Assert.assertEquals((String)("Event type at " + this.getLocation()), (long)expectedNextEvent, (long)this.actual.next());
        }
    }
}

