/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.suite;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public abstract class MatrixTestSuiteBuilder {
    private final List<Exclude> excludes = new ArrayList<Exclude>();
    private TestSuite suite;

    public final void exclude(Class<? extends MatrixTestCase> testClass, String filter) {
        try {
            this.excludes.add(new Exclude(testClass, filter == null ? null : FrameworkUtil.createFilter((String)filter)));
        }
        catch (InvalidSyntaxException ex) {
            throw new IllegalArgumentException("Invalid filter expression", ex);
        }
    }

    public final void exclude(Class<? extends MatrixTestCase> testClass) {
        this.exclude(testClass, null);
    }

    public final void exclude(String filter) {
        this.exclude(null, filter);
    }

    protected abstract void addTests();

    public final TestSuite build() {
        this.suite = new TestSuite();
        this.addTests();
        return this.suite;
    }

    protected final void addTest(MatrixTestCase test) {
        for (Exclude exclude : this.excludes) {
            if (!exclude.accept(test)) continue;
            return;
        }
        this.suite.addTest((Test)test);
    }

    private static class Exclude {
        private final Class<? extends MatrixTestCase> testClass;
        private final Filter filter;

        public Exclude(Class<? extends MatrixTestCase> testClass, Filter filter) {
            this.testClass = testClass;
            this.filter = filter;
        }

        public boolean accept(MatrixTestCase test) {
            return !(this.testClass != null && !((Object)((Object)test)).getClass().equals(this.testClass) || this.filter != null && !this.filter.match(test.getTestParameters()));
        }
    }
}

