/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.stax;

import java.io.StringReader;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.InputSource;

public interface Normalizer<T> {
    public static final Normalizer<String> LOWER_CASE = new Normalizer<String>(){

        @Override
        public String normalize(String value) {
            return value == null ? null : value.toLowerCase(Locale.ENGLISH);
        }
    };
    public static final Normalizer<String> DTD = new Normalizer<String>(){

        @Override
        public String normalize(String content) throws Exception {
            if (content == null || content.trim().length() == 0) {
                return null;
            }
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader("<!DOCTYPE root [" + content + "]><root/>"))).getDoctype().getInternalSubset();
        }
    };
    public static final Normalizer<String> EMPTY_STRING_TO_NULL = new Normalizer<String>(){

        @Override
        public String normalize(String value) {
            return "".equals(value) ? null : value;
        }
    };

    public T normalize(T var1) throws Exception;
}

