/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.value;

import java.io.Serializable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Primitives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongValue
implements Comparable<LongValue>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final long value;

    public LongValue(long value) {
        this.value = value;
    }

    @Override
    public final int compareTo(LongValue that) {
        if (this.value < that.value) {
            return -1;
        }
        if (this.value > that.value) {
            return 1;
        }
        return 0;
    }

    public final boolean equals(Object that) {
        if (that instanceof LongValue) {
            return this.value == ((LongValue)that).value;
        }
        return false;
    }

    public final boolean greaterThan(long value) {
        return this.value > value;
    }

    public final boolean greaterThanOrEqual(long value) {
        return this.value >= value;
    }

    public final boolean greaterThan(LongValue that) {
        return this.value > that.value;
    }

    public final boolean greaterThanOrEqual(LongValue that) {
        return this.value >= that.value;
    }

    public final int hashCode() {
        return Primitives.hashCode(this.value);
    }

    public final boolean lessThan(long that) {
        return this.value < that;
    }

    public final boolean lessThanOrEqual(long that) {
        return this.value <= that;
    }

    public final boolean lessThan(LongValue that) {
        return this.value < that.value;
    }

    public final boolean lessThanOrEqual(LongValue that) {
        return this.value <= that.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static <T extends LongValue> T max(T lhs, T rhs) {
        Args.notNull(lhs, "lhs");
        Args.notNull(rhs, "rhs");
        if (lhs.compareTo(rhs) > 0) {
            return lhs;
        }
        return rhs;
    }

    public static <T extends LongValue> T maxNullSafe(T lhs, T rhs) {
        if (lhs == rhs) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return LongValue.max(lhs, rhs);
    }
}

