/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.license;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.wicket.util.diff.Diff;
import org.apache.wicket.util.diff.Revision;
import org.apache.wicket.util.license.AbstractLicenseHeaderHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertiesLicenseHeaderHandler
extends AbstractLicenseHeaderHandler {
    public PropertiesLicenseHeaderHandler(List<String> ignoreFiles) {
        super(ignoreFiles);
    }

    @Override
    protected String getLicenseHeaderFilename() {
        return "propertiesLicense.txt";
    }

    @Override
    public boolean checkLicenseHeader(File file) {
        Revision revision = null;
        try {
            String header = this.extractLicenseHeader(file, 0, 14);
            revision = Diff.diff(this.getLicenseHeader().split(LINE_ENDING), header.split(LINE_ENDING));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        return revision.size() == 0;
    }

    @Override
    public List<String> getSuffixes() {
        return Arrays.asList("properties");
    }

    @Override
    public boolean addLicenseHeader(File file) {
        this.prependLicenseHeader(file);
        return true;
    }
}

