/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring.injection.annot;

import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.LazyInitProxyFactory;
import org.apache.wicket.spring.ISpringContextLocator;
import org.apache.wicket.spring.SpringBeanLocator;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.ResolvableType;

public class AnnotProxyFieldValueFactory
implements IFieldValueFactory {
    private final ISpringContextLocator contextLocator;
    private final ConcurrentMap<SpringBeanLocator, Object> cache = Generics.newConcurrentHashMap();
    private final ConcurrentMap<AbstractMap.SimpleEntry<Class<?>, Class<?>>, String> beanNameCache = Generics.newConcurrentHashMap();
    private final boolean wrapInProxies;

    public AnnotProxyFieldValueFactory(ISpringContextLocator contextLocator) {
        this(contextLocator, true);
    }

    public AnnotProxyFieldValueFactory(ISpringContextLocator contextLocator, boolean wrapInProxies) {
        this.contextLocator = (ISpringContextLocator)Args.notNull((Object)contextLocator, (String)"contextLocator");
        this.wrapInProxies = wrapInProxies;
    }

    public Object getFieldValue(Field field, Object fieldOwner) {
        if (this.supportsField(field)) {
            Object tmpTarget;
            Object target;
            boolean required;
            String name;
            SpringBean annot = field.getAnnotation(SpringBean.class);
            if (annot != null) {
                name = annot.name();
                required = annot.required();
            } else {
                Named named = field.getAnnotation(Named.class);
                name = named != null ? named.value() : "";
                required = true;
            }
            Class generic = ResolvableType.forField((Field)field).resolveGeneric(new int[]{0});
            String beanName = this.getBeanName(field, name, required, generic);
            SpringBeanLocator locator = new SpringBeanLocator(beanName, field.getType(), field, this.contextLocator);
            Object cachedValue = this.cache.get(locator);
            if (cachedValue != null) {
                return cachedValue;
            }
            try {
                target = locator.locateProxyTarget();
            }
            catch (IllegalStateException isx) {
                if (required) {
                    throw isx;
                }
                return null;
            }
            if (this.wrapInProxies) {
                target = LazyInitProxyFactory.createProxy(field.getType(), (IProxyTargetLocator)locator);
            }
            if (locator.isSingletonBean() && (tmpTarget = this.cache.putIfAbsent(locator, target)) != null) {
                target = tmpTarget;
            }
            return target;
        }
        return null;
    }

    private String getBeanName(Field field, String name, boolean required, Class<?> generic) {
        if (Strings.isEmpty((CharSequence)name)) {
            String tmpName;
            Class<?> fieldType = field.getType();
            AbstractMap.SimpleEntry keyPair = new AbstractMap.SimpleEntry(fieldType, generic);
            name = (String)this.beanNameCache.get(fieldType);
            if (name == null && (name = this.getBeanNameOfClass(this.contextLocator.getSpringContext(), fieldType, generic, field.getName())) != null && (tmpName = this.beanNameCache.putIfAbsent(keyPair, name)) != null) {
                name = tmpName;
            }
        }
        return name;
    }

    private String getBeanNameOfClass(ApplicationContext ctx, Class<?> clazz, Class<?> generic, String fieldName) {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)ctx, clazz)));
        if (ctx instanceof AbstractApplicationContext) {
            Iterator it = names.iterator();
            while (it.hasNext()) {
                String possibility = (String)it.next();
                BeanDefinition beanDef = this.getBeanDefinition(((AbstractApplicationContext)ctx).getBeanFactory(), possibility);
                if (!BeanFactoryUtils.isFactoryDereference((String)possibility) && !possibility.startsWith("scopedTarget.") && (beanDef == null || beanDef.isAutowireCandidate())) continue;
                it.remove();
            }
        }
        if (names.size() > 1) {
            int nameIndex;
            if (ctx instanceof AbstractApplicationContext) {
                ArrayList<String> primaries = new ArrayList<String>();
                for (String name : names) {
                    BeanDefinition beanDef = this.getBeanDefinition(((AbstractApplicationContext)ctx).getBeanFactory(), name);
                    if (!(beanDef instanceof AbstractBeanDefinition) || !beanDef.isPrimary()) continue;
                    primaries.add(name);
                }
                if (primaries.size() == 1) {
                    return (String)primaries.get(0);
                }
            }
            if ((nameIndex = names.indexOf(fieldName)) > -1) {
                return (String)names.get(nameIndex);
            }
            if (generic != null) {
                return null;
            }
            StringBuilder msg = new StringBuilder();
            msg.append("More than one bean of type [");
            msg.append(clazz.getName());
            msg.append("] found, you have to specify the name of the bean ");
            msg.append("(@SpringBean(name=\"foo\")) or (@Named(\"foo\") if using @javax.inject classes) in order to resolve this conflict. ");
            msg.append("Matched beans: ");
            msg.append(Strings.join((String)",", names));
            throw new IllegalStateException(msg.toString());
        }
        if (!names.isEmpty()) {
            return (String)names.get(0);
        }
        return null;
    }

    public BeanDefinition getBeanDefinition(ConfigurableListableBeanFactory beanFactory, String name) {
        if (beanFactory.containsBeanDefinition(name)) {
            return beanFactory.getBeanDefinition(name);
        }
        BeanFactory parent = beanFactory.getParentBeanFactory();
        if (parent != null && parent instanceof ConfigurableListableBeanFactory) {
            return this.getBeanDefinition((ConfigurableListableBeanFactory)parent, name);
        }
        return null;
    }

    public boolean supportsField(Field field) {
        return field.isAnnotationPresent(SpringBean.class) || field.isAnnotationPresent(Inject.class);
    }
}

