/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.parameter;

import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.Strings;

public class PageParametersEncoder
implements IPageParametersEncoder {
    @Override
    public PageParameters decodePageParameters(Url url) {
        PageParameters parameters = new PageParameters();
        int i = 0;
        for (String s : url.getSegments()) {
            parameters.set(i, (Object)s);
            ++i;
        }
        for (Url.QueryParameter p : url.getQueryParameters()) {
            String parameterName = p.getName();
            if (Strings.isEmpty((CharSequence)parameterName)) continue;
            parameters.add(parameterName, p.getValue(), INamedParameters.Type.QUERY_STRING);
        }
        return parameters.isEmpty() ? null : parameters;
    }

    @Override
    public Url encodePageParameters(PageParameters pageParameters) {
        Url url = new Url();
        if (pageParameters != null) {
            for (int i = 0; i < pageParameters.getIndexedCount(); ++i) {
                url.getSegments().add(pageParameters.get(i).toString());
            }
            for (INamedParameters.NamedPair pair : pageParameters.getAllNamed()) {
                Url.QueryParameter param = new Url.QueryParameter(pair.getKey(), pair.getValue());
                url.getQueryParameters().add(param);
            }
        }
        return url;
    }
}

