/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.inspector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.DefaultTableTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.ISortableTreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.table.TreeColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableTreeProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.debug.PageView;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.CheckBoxMultipleChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.Strings;

public final class EnhancedPageView
extends GenericPanel<Page> {
    private static final long serialVersionUID = 1L;
    private ExpandState expandState = new ExpandState();
    private boolean showStatefulAndParentsOnly;
    private boolean showBehaviors;
    private List<IColumn<TreeNode, Void>> allColumns;
    private List<IColumn<TreeNode, Void>> visibleColumns;
    private AbstractTree<TreeNode> componentTree;

    public EnhancedPageView(String id, Page page) {
        this(id, EnhancedPageView.getModelFor(page == null ? null : page.getPageReference()));
    }

    private static IModel<Page> getModelFor(final PageReference pageRef) {
        return new LoadableDetachableModel<Page>(){
            private static final long serialVersionUID = 1L;

            protected Page load() {
                if (pageRef == null) {
                    return null;
                }
                Page page = pageRef.getPage();
                return page;
            }
        };
    }

    public EnhancedPageView(String id, IModel<Page> pageModel) {
        super(id, pageModel);
        this.expandState.expandAll();
        this.showStatefulAndParentsOnly = false;
        this.showBehaviors = true;
        this.allColumns = this.allColumns();
        this.visibleColumns = new ArrayList<IColumn<TreeNode, Void>>(this.allColumns);
        this.add(new Component[]{new Label("info", (IModel)new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                Page page = (Page)EnhancedPageView.this.getModelObject();
                return page == null ? "[Stateless Page]" : page.toString();
            }
        })});
        Model<String> pageRenderDuration = new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                Long renderTime;
                Page page = (Page)EnhancedPageView.this.getModelObject();
                if (page != null && (renderTime = (Long)page.getMetaData(PageView.RENDER_KEY)) != null) {
                    return renderTime.toString();
                }
                return "n/a";
            }
        };
        this.add(new Component[]{new Label("pageRenderDuration", (IModel)pageRenderDuration)});
        this.addTreeControls();
        this.componentTree = this.newTree();
        this.add(new Component[]{this.componentTree});
    }

    private List<IColumn<TreeNode, Void>> allColumns() {
        ArrayList<IColumn<TreeNode, Void>> columns = new ArrayList<IColumn<TreeNode, Void>>();
        columns.add((IColumn<TreeNode, Void>)new PropertyColumn<TreeNode, Void>((IModel)Model.of((Serializable)((Object)"Path")), "path"){
            private static final long serialVersionUID = 1L;

            public String getCssClass() {
                return "col_path";
            }

            public String toString() {
                return (String)this.getDisplayModel().getObject();
            }
        });
        columns.add((IColumn<TreeNode, Void>)new TreeColumn<TreeNode, Void>((IModel)Model.of((Serializable)((Object)"Tree"))){
            private static final long serialVersionUID = 1L;

            public String toString() {
                return (String)this.getDisplayModel().getObject();
            }
        });
        columns.add((IColumn<TreeNode, Void>)new PropertyColumn<TreeNode, Void>((IModel)Model.of((Serializable)((Object)"Stateless")), "stateless"){
            private static final long serialVersionUID = 1L;

            public String getCssClass() {
                return "col_stateless";
            }

            public String toString() {
                return (String)this.getDisplayModel().getObject();
            }
        });
        columns.add((IColumn<TreeNode, Void>)new PropertyColumn<TreeNode, Void>((IModel)Model.of((Serializable)((Object)"Render time (ms)")), "renderTime"){
            private static final long serialVersionUID = 1L;

            public String getCssClass() {
                return "col_renderTime";
            }

            public String toString() {
                return (String)this.getDisplayModel().getObject();
            }
        });
        columns.add((IColumn<TreeNode, Void>)new AbstractColumn<TreeNode, Void>((IModel)Model.of((Serializable)((Object)"Size"))){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<ICellPopulator<TreeNode>> item, String componentId, IModel<TreeNode> rowModel) {
                item.add(new Component[]{new Label(componentId, (Serializable)((Object)Bytes.bytes((long)((TreeNode)rowModel.getObject()).getSize()).toString()))});
            }

            public String getCssClass() {
                return "col_size";
            }

            public String toString() {
                return (String)this.getDisplayModel().getObject();
            }
        });
        columns.add((IColumn<TreeNode, Void>)new PropertyColumn<TreeNode, Void>((IModel)Model.of((Serializable)((Object)"Type")), "type"){
            private static final long serialVersionUID = 1L;

            public String toString() {
                return (String)this.getDisplayModel().getObject();
            }
        });
        columns.add((IColumn<TreeNode, Void>)new PropertyColumn<TreeNode, Void>((IModel)Model.of((Serializable)((Object)"Model Object")), "model"){
            private static final long serialVersionUID = 1L;

            public String toString() {
                return (String)this.getDisplayModel().getObject();
            }
        });
        return columns;
    }

    private void addTreeControls() {
        Form form = new Form("form");
        this.add(new Component[]{form});
        form.add(new Component[]{new CheckBox("showStateless", (IModel)new PropertyModel((Object)this, "showStatefulAndParentsOnly"))});
        form.add(new Component[]{new CheckBox("showBehaviors", (IModel)new PropertyModel((Object)this, "showBehaviors"))});
        form.add(new Component[]{new CheckBoxMultipleChoice("visibleColumns", (IModel)new PropertyModel((Object)this, "visibleColumns"), this.allColumns).setSuffix(" ")});
        form.add(new Component[]{new AjaxFallbackButton("submit", form){
            private static final long serialVersionUID = 1L;

            protected void onAfterSubmit(AjaxRequestTarget target) {
                if (target != null) {
                    target.add(new Component[]{EnhancedPageView.this.componentTree});
                }
            }
        }});
        this.add(new Component[]{new AjaxFallbackLink<Void>("expandAll"){
            private static final long serialVersionUID = 1L;

            public void onClick(Optional<AjaxRequestTarget> targetOptional) {
                EnhancedPageView.this.expandState.expandAll();
                targetOptional.ifPresent(target -> target.add(new Component[]{EnhancedPageView.this.componentTree}));
            }
        }});
        this.add(new Component[]{new AjaxFallbackLink<Void>("collapseAll"){
            private static final long serialVersionUID = 1L;

            public void onClick(Optional<AjaxRequestTarget> targetOptional) {
                EnhancedPageView.this.expandState.collapseAll();
                targetOptional.ifPresent(target -> target.add(new Component[]{EnhancedPageView.this.componentTree}));
            }
        }});
    }

    private AbstractTree<TreeNode> newTree() {
        TreeProvider provider = new TreeProvider();
        LoadableDetachableModel<Set<TreeNode>> expandStateModel = new LoadableDetachableModel<Set<TreeNode>>(){
            private static final long serialVersionUID = 1L;

            protected Set<TreeNode> load() {
                return EnhancedPageView.this.expandState;
            }
        };
        DefaultTableTree<TreeNode, Void> tree = new DefaultTableTree<TreeNode, Void>("tree", this.visibleColumns, (ISortableTreeProvider)provider, Integer.MAX_VALUE, (IModel)expandStateModel){
            private static final long serialVersionUID = 1L;

            protected Item<TreeNode> newRowItem(String id, int index, IModel<TreeNode> model) {
                return new OddEvenItem(id, index, model);
            }
        };
        tree.setOutputMarkupId(true);
        return tree;
    }

    private static class ExpandState
    implements Set<TreeNode>,
    IClusterable {
        private static final long serialVersionUID = 1L;
        private HashSet<List<Integer>> set = new HashSet();
        private boolean reversed = false;

        private ExpandState() {
        }

        public void expandAll() {
            this.set.clear();
            this.reversed = true;
        }

        public void collapseAll() {
            this.set.clear();
            this.reversed = false;
        }

        @Override
        public boolean add(TreeNode a_e) {
            List<Integer> pathIndexes = a_e.getPathIndexes();
            if (this.reversed) {
                return this.set.remove(pathIndexes);
            }
            return this.set.add(pathIndexes);
        }

        @Override
        public boolean remove(Object a_o) {
            TreeNode item = (TreeNode)a_o;
            List<Integer> pathIndexes = item.getPathIndexes();
            if (this.reversed) {
                return this.set.add(pathIndexes);
            }
            return this.set.remove(pathIndexes);
        }

        @Override
        public boolean contains(Object a_o) {
            TreeNode item = (TreeNode)a_o;
            List<Integer> pathIndexes = item.getPathIndexes();
            if (this.reversed) {
                return !this.set.contains(pathIndexes);
            }
            return this.set.contains(pathIndexes);
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<TreeNode> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a_a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> a_c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends TreeNode> a_c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> a_c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> a_c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class TreeProvider
    extends SortableTreeProvider<TreeNode, Void> {
        private static final long serialVersionUID = 1L;
        private TreeModel componentTreeModel = new TreeModel();

        private TreeProvider() {
        }

        public void detach() {
            this.componentTreeModel.detach();
        }

        public Iterator<? extends TreeNode> getRoots() {
            TreeNode tree = (TreeNode)this.componentTreeModel.getObject();
            List<Object> roots = tree == null ? Collections.emptyList() : Arrays.asList(tree);
            return roots.iterator();
        }

        public boolean hasChildren(TreeNode node) {
            return node.hasChildren();
        }

        public Iterator<? extends TreeNode> getChildren(TreeNode node) {
            return node.children.iterator();
        }

        public IModel<TreeNode> model(TreeNode object) {
            return new TreeNodeModel(object);
        }

        private class TreeNodeModel
        extends LoadableDetachableModel<TreeNode> {
            private static final long serialVersionUID = 1L;
            private List<Integer> path;

            public TreeNodeModel(TreeNode treeNode) {
                super((Object)treeNode);
                this.path = treeNode.getPathIndexes();
            }

            protected TreeNode load() {
                TreeNode tree;
                TreeNode currentItem = tree = (TreeNode)TreeProvider.this.componentTreeModel.getObject();
                for (Integer index : this.path) {
                    currentItem = currentItem.children.get(index);
                }
                return currentItem;
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj instanceof TreeNodeModel) {
                    return ((TreeNodeModel)((Object)obj)).path.equals(this.path);
                }
                return false;
            }
        }

        private class TreeModel
        extends LoadableDetachableModel<TreeNode> {
            private static final long serialVersionUID = 1L;

            private TreeModel() {
            }

            protected TreeNode load() {
                Page page = (Page)EnhancedPageView.this.getModelObject();
                if (page == null) {
                    return null;
                }
                return this.buildTree((Component)page, null);
            }

            private TreeNode buildTree(Component node, TreeNode parent) {
                TreeNode treeNode = new TreeNode((IClusterable)node, parent);
                List<TreeNode> children = treeNode.children;
                if (EnhancedPageView.this.showBehaviors) {
                    for (Behavior behavior : node.getBehaviors()) {
                        if (EnhancedPageView.this.showStatefulAndParentsOnly && behavior.getStatelessHint(node)) continue;
                        children.add(new TreeNode((IClusterable)behavior, treeNode));
                    }
                }
                if (node instanceof MarkupContainer) {
                    MarkupContainer container = (MarkupContainer)node;
                    for (Component child : container) {
                        this.buildTree(child, treeNode);
                    }
                }
                Collections.sort(children, new Comparator<TreeNode>(){

                    @Override
                    public int compare(TreeNode o1, TreeNode o2) {
                        if (o1.node instanceof Component) {
                            if (o2.node instanceof Component) {
                                return o1.getPath().compareTo(o2.getPath());
                            }
                            return 1;
                        }
                        if (o2.node instanceof Component) {
                            return -1;
                        }
                        return o1.getPath().compareTo(o2.getPath());
                    }
                });
                if (!(parent == null || EnhancedPageView.this.showStatefulAndParentsOnly && !treeNode.hasChildren() && node.isStateless())) {
                    parent.children.add(treeNode);
                }
                return treeNode;
            }
        }
    }

    private static class TreeNode {
        public IClusterable node;
        public TreeNode parent;
        public List<TreeNode> children;

        public TreeNode(IClusterable node, TreeNode parent) {
            this.node = node;
            this.parent = parent;
            this.children = new ArrayList<TreeNode>();
            if (!(node instanceof Component) && !(node instanceof Behavior)) {
                throw new IllegalArgumentException("Only accepts Components and Behaviors");
            }
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public List<Integer> getPathIndexes() {
            TreeNode parent;
            ArrayList<Integer> path = new ArrayList<Integer>();
            TreeNode nextChild = this;
            while ((parent = nextChild.parent) != null) {
                int indexOf = parent.children.indexOf(nextChild);
                if (indexOf < 0) {
                    throw new AssertionError((Object)"Child not found in parent");
                }
                path.add(indexOf);
                nextChild = parent;
            }
            Collections.reverse(path);
            return path;
        }

        public String getPath() {
            if (this.node instanceof Component) {
                return ((Component)this.node).getPath();
            }
            Behavior behavior = (Behavior)this.node;
            Component parent = (Component)this.parent.node;
            String parentPath = parent.getPath();
            int indexOf = parent.getBehaviors().indexOf(behavior);
            return parentPath + ':' + "Behavior_" + indexOf;
        }

        public String getRenderTime() {
            Long renderDuration;
            if (this.node instanceof Component && (renderDuration = (Long)((Component)this.node).getMetaData(PageView.RENDER_KEY)) != null) {
                return renderDuration.toString();
            }
            return "n/a";
        }

        public long getSize() {
            if (this.node instanceof Component) {
                long size = ((Component)this.node).getSizeInBytes();
                return size;
            }
            long size = WicketObjects.sizeof((Serializable)this.node);
            return size;
        }

        public String getType() {
            String type = this.node.getClass().getName();
            if (type.indexOf("$") > 0) {
                type = this.node.getClass().getSuperclass().getName();
            }
            return type;
        }

        public String getModel() {
            if (this.node instanceof Component) {
                String model;
                try {
                    model = ((Component)this.node).getDefaultModelObjectAsString();
                }
                catch (Exception e) {
                    model = e.getMessage();
                }
                return model;
            }
            return null;
        }

        public boolean isStateless() {
            if (this.node instanceof Page) {
                return ((Page)this.node).isPageStateless();
            }
            if (this.node instanceof Component) {
                return ((Component)this.node).isStateless();
            }
            Behavior behavior = (Behavior)this.node;
            Component parent = (Component)this.parent.node;
            return behavior.getStatelessHint(parent);
        }

        public String toString() {
            if (this.node instanceof Page) {
                String type = this.getType();
                type = Strings.lastPathComponent((String)type, (char)'.');
                return type;
            }
            if (this.node instanceof Component) {
                return ((Component)this.node).getId();
            }
            String type = this.getType();
            type = Strings.lastPathComponent((String)type, (char)'.');
            return type;
        }
    }
}

