/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.stylemap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.metadata.Capability;

public class AnnotationFeaturesViewer
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -2455669190592868013L;
    public static final String ROOT = "Root";
    private JScrollPane scrollPane;
    private JTree tree;
    private JButton expandAllButton;
    private JButton collapseAllButton;

    public AnnotationFeaturesViewer() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.add((Component)this.scrollPane, "Center");
        JPanel buttonsPanel = new JPanel();
        this.expandAllButton = new JButton("Expand All");
        this.expandAllButton.setToolTipText("Expand all tree nodes");
        this.expandAllButton.addActionListener(this);
        buttonsPanel.add(this.expandAllButton);
        this.collapseAllButton = new JButton("Collapse All");
        this.collapseAllButton.setToolTipText("Collapse all tree nodes");
        this.collapseAllButton.addActionListener(this);
        buttonsPanel.add(this.collapseAllButton);
        this.add((Component)buttonsPanel, "North");
    }

    public void populate(AnalysisEngineDescription analysisEngine, AnalysisEngineMetaData aeMetaData, CAS cas) {
        this.tree = this.generateTreeView(analysisEngine, aeMetaData, cas);
        this.tree.setDragEnabled(true);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        TreeSelectionModel selectionModel = this.tree.getSelectionModel();
        selectionModel.setSelectionMode(1);
        DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer();
        cellRenderer.setLeafIcon(null);
        cellRenderer.setClosedIcon(null);
        cellRenderer.setOpenIcon(null);
        this.tree.setCellRenderer(cellRenderer);
        this.scrollPane.getViewport().add((Component)this.tree, null);
    }

    private JTree generateTreeView(AnalysisEngineDescription analysisEngine, AnalysisEngineMetaData aeMetaData, CAS cas) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(ROOT);
        ArrayList<String> annotationTypes = new ArrayList<String>();
        Capability[] capabilities = aeMetaData.getCapabilities();
        for (int i = 0; i < capabilities.length; ++i) {
            TypeOrFeature[] outputs = capabilities[i].getOutputs();
            for (int j = 0; j < outputs.length; ++j) {
                if (!outputs[j].isType() || annotationTypes.contains(outputs[j].getName())) continue;
                annotationTypes.add(outputs[j].getName());
            }
        }
        Iterator it = annotationTypes.iterator();
        String annotationTypeName = "";
        while (it.hasNext()) {
            annotationTypeName = (String)it.next();
            DefaultMutableTreeNode annotationTreeNode = new DefaultMutableTreeNode(annotationTypeName);
            if (annotationTreeNode != null) {
                String[] featureNames = this.getFeatureNamesForType(annotationTypeName, cas);
                if (featureNames != null) {
                    for (int i = 0; i < featureNames.length; ++i) {
                        DefaultMutableTreeNode featureTreeNode = new DefaultMutableTreeNode(featureNames[i]);
                        annotationTreeNode.add(featureTreeNode);
                    }
                    root.add(annotationTreeNode);
                    continue;
                }
                JOptionPane.showMessageDialog(null, "Can't get feature names for: " + annotationTypeName, "XML error", 0);
                continue;
            }
            JOptionPane.showMessageDialog(null, "Annotation type does not exist: " + annotationTypeName, "XML error", 0);
        }
        return new JTree(root);
    }

    private String[] getFeatureNamesForType(String aTypeName, CAS cas) {
        TypeSystem ts = cas.getTypeSystem();
        Type t = ts.getType(aTypeName);
        if (t != null) {
            List features = t.getFeatures();
            String[] featNames = new String[features.size()];
            for (int i = 0; i < features.size(); ++i) {
                Feature f = (Feature)features.get(i);
                featNames[i] = f.getShortName();
            }
            return featNames;
        }
        return null;
    }

    public String getSelection() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            String parentPath = treePath.getParentPath().getLastPathComponent().toString();
            String lastPath = treePath.getLastPathComponent().toString();
            if (parentPath.equals(ROOT)) {
                return lastPath;
            }
            return parentPath + ":" + lastPath;
        }
        return null;
    }

    public void addTreeSelectionListener(TreeSelectionListener sel) {
        this.tree.addTreeSelectionListener(sel);
    }

    public void actionPerformed(ActionEvent e) {
        block3: {
            Object source;
            block2: {
                source = e.getSource();
                if (source != this.expandAllButton) break block2;
                for (int i = 0; i < this.tree.getRowCount(); ++i) {
                    this.tree.expandRow(i);
                }
                break block3;
            }
            if (source != this.collapseAllButton) break block3;
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.collapseRow(i);
            }
        }
    }
}

