/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import org.apache.uima.tools.cvd.MainFrame;

public class FileSaveAsEventHandler
implements ActionListener {
    private final MainFrame main;

    public FileSaveAsEventHandler(MainFrame frame) {
        this.main = frame;
    }

    public void actionPerformed(ActionEvent event) {
        int rc;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Save file as...");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogType(1);
        if (this.main.getFileOpenDir() != null) {
            fileChooser.setCurrentDirectory(this.main.getFileOpenDir());
        }
        if ((rc = fileChooser.showSaveDialog(this.main)) == 0) {
            File tmp = this.main.getTextFile();
            File fileToSaveTo = fileChooser.getSelectedFile();
            if (!this.main.confirmOverwrite(fileToSaveTo)) {
                return;
            }
            this.main.setTextFile(fileToSaveTo);
            boolean fileSaved = this.main.saveFile();
            if (fileSaved) {
                this.main.setDirty(false);
                this.main.setTitle();
                this.main.setSaveTextFileEnable(true);
                this.main.setFileStatusMessage();
                this.main.setStatusbarMessage("Text file " + this.main.getTextFile().getName() + " saved.");
            } else {
                this.main.setTextFile(tmp);
            }
        }
    }
}

