/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentFilesList {
    private final List<File> list = new ArrayList<File>();
    private final int max;

    public RecentFilesList(int maxSize) {
        this.max = maxSize;
    }

    public List<File> getFileList() {
        return this.list;
    }

    public void appendFile(File file) {
        if (this.list.size() < this.max) {
            this.list.add(file);
        }
    }

    public void addFile(File file) {
        if (this.list.contains(file)) {
            int filePos = this.list.indexOf(file);
            for (int i = filePos - 1; i >= 0; --i) {
                this.list.set(i + 1, this.list.get(i));
            }
            this.list.set(0, file);
        } else if (this.list.isEmpty()) {
            this.list.add(file);
        } else {
            this.shiftRight();
            this.list.set(0, file);
        }
    }

    private final void shiftRight() {
        if (this.list.size() < this.max) {
            this.list.add(this.list.get(this.list.size() - 1));
        }
        for (int i = this.list.size() - 2; i >= 0; --i) {
            this.list.set(i + 1, this.list.get(i));
        }
    }

    public List<String> toStringList() {
        ArrayList<String> out = new ArrayList<String>();
        for (File file : this.list) {
            out.add(file.getAbsolutePath());
        }
        return out;
    }
}

