/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.uima.tools.cvd.FSNode;

public class StringFsPopupEventAdapter
extends MouseAdapter {
    public void mousePressed(MouseEvent e) {
        this.showPopupMaybe(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.showPopupMaybe(e);
    }

    private void showPopupMaybe(MouseEvent e) {
        FSNode node;
        JTree tree;
        TreePath path;
        Object leafComponent;
        Object o;
        if (e.isPopupTrigger() && (o = e.getSource()) instanceof JTree && (leafComponent = (path = (tree = (JTree)o).getPathForLocation(e.getX(), e.getY())).getLastPathComponent()) instanceof FSNode && (node = (FSNode)leafComponent).getNodeClass() == 2 && node.isShortenedString()) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem showStringItem = new JMenuItem("Show full string");
            showStringItem.addActionListener(new ShowStringHandler(node.getFullString()));
            menu.add(showStringItem);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private static class ShowStringHandler
    implements ActionListener {
        private String string;

        private ShowStringHandler(String s) {
            this.string = s;
        }

        public void actionPerformed(ActionEvent e) {
            JFrame frame = new JFrame("Full string value");
            JTextArea textArea = new JTextArea(this.string);
            textArea.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(textArea);
            frame.setContentPane(scrollPane);
            frame.pack();
            frame.setVisible(true);
        }
    }
}

