/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.apache.uima.util.FileUtils;

public class LogFileViewer
extends JFrame {
    private static final long serialVersionUID = 3599235286749804258L;
    private File logFile;
    private JScrollPane scrollPane;
    private JTextArea textArea;

    public LogFileViewer() {
    }

    public LogFileViewer(GraphicsConfiguration arg0) {
        super(arg0);
    }

    public LogFileViewer(String arg0) {
        super(arg0);
    }

    public LogFileViewer(String arg0, GraphicsConfiguration arg1) {
        super(arg0, arg1);
    }

    public void init(File file, Dimension d) {
        this.createMenus();
        this.logFile = file;
        this.textArea = new JTextArea();
        Action copyAction = this.textArea.getActionMap().get("copy-to-clipboard");
        copyAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        copyAction.setEnabled(true);
        this.scrollPane = new JScrollPane(this.textArea);
        this.setContentPane(this.scrollPane);
        this.scrollPane.setPreferredSize(d);
        boolean doneLoadingFile = this.loadFile();
        if (!doneLoadingFile) {
            this.dispose();
            return;
        }
        this.pack();
        this.setVisible(true);
    }

    private void createMenus() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenuItem reload = new JMenuItem("Reload Log File");
        reload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LogFileViewer.this.loadFile();
            }
        });
        fileMenu.add(reload);
        JMenuItem exit = new JMenuItem("Close Window");
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LogFileViewer.this.dispose();
            }
        });
        fileMenu.add(exit);
    }

    private boolean loadFile() {
        if (!this.logFile.exists()) {
            JOptionPane.showMessageDialog(this, "The log file \"" + this.logFile.getAbsolutePath() + "\" does not exist (yet).\nThis probably just means that nothing was logged yet.", "Information", 1);
            return false;
        }
        String text = null;
        try {
            text = FileUtils.file2String((File)this.logFile, (String)"UTF-8");
        }
        catch (IOException e) {
            this.handleException(e);
            return false;
        }
        this.textArea.setText(text);
        return true;
    }

    protected void handleException(Exception e) {
        boolean hasAsserts = false;
        if (hasAsserts) {
            e.printStackTrace();
        }
        JOptionPane.showMessageDialog(this, e.getMessage(), "Exception", 0);
    }
}

