/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.stylemap;

import java.awt.Color;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.uima.tools.stylemap.StyleMapEntry;

public class ColorParser {
    private HashMap colorNameMap;

    public ColorParser() {
        this.initializeColorNameMap();
    }

    private void initializeColorNameMap() {
        this.colorNameMap = new HashMap();
        this.colorNameMap.put("#000000", "black");
        this.colorNameMap.put("#c0c0c0", "silver");
        this.colorNameMap.put("#808080", "gray");
        this.colorNameMap.put("#ffffff", "white");
        this.colorNameMap.put("#800000", "maroon");
        this.colorNameMap.put("#ff0000", "red");
        this.colorNameMap.put("#800080", "purple");
        this.colorNameMap.put("#ff00ff", "fuchsia");
        this.colorNameMap.put("#008000", "green");
        this.colorNameMap.put("#00ff00", "lime");
        this.colorNameMap.put("#808000", "olive");
        this.colorNameMap.put("#ffff00", "yellow");
        this.colorNameMap.put("#000080", "navy");
        this.colorNameMap.put("#0000ff", "blue");
        this.colorNameMap.put("#00ffff", "aqua");
        this.colorNameMap.put("#000000", "black");
        this.colorNameMap.put("#add8e6", "lightblue");
        this.colorNameMap.put("#90ee90", "lightgreen");
        this.colorNameMap.put("#ffa500", "orange");
        this.colorNameMap.put("#ffc0cb", "pink");
        this.colorNameMap.put("#fa8072", "salmon");
        this.colorNameMap.put("#00ffff", "cyan");
        this.colorNameMap.put("#ee82ee", "violet");
        this.colorNameMap.put("#d2b48c", "tan");
        this.colorNameMap.put("#a52a2a", "brown");
        this.colorNameMap.put("#ffffff", "white");
        this.colorNameMap.put("#9370db", "mediumpurple");
        this.colorNameMap.put("black", "#000000");
        this.colorNameMap.put("silver", "#c0c0c0");
        this.colorNameMap.put("gray", "#808080");
        this.colorNameMap.put("white", "#ffffff");
        this.colorNameMap.put("maroon", "#800000");
        this.colorNameMap.put("red", "#ff0000");
        this.colorNameMap.put("purple", "#800080");
        this.colorNameMap.put("fuchsia", "#ff00ff");
        this.colorNameMap.put("green", "#008000");
        this.colorNameMap.put("lime", "#00ff00");
        this.colorNameMap.put("olive", "#808000");
        this.colorNameMap.put("yellow", "#ffff00");
        this.colorNameMap.put("navy", "#000080");
        this.colorNameMap.put("blue", "#0000ff");
        this.colorNameMap.put("aqua", "#00ffff");
        this.colorNameMap.put("black", "#000000");
        this.colorNameMap.put("lightblue", "#add8e6");
        this.colorNameMap.put("lightgreen", "#90ee90");
        this.colorNameMap.put("orange", "#ffa500");
        this.colorNameMap.put("pink", "#ffc0cb");
        this.colorNameMap.put("salmon", "#fa8072");
        this.colorNameMap.put("cyan", "#00ffff");
        this.colorNameMap.put("violet", "#ee82ee");
        this.colorNameMap.put("tan", "#d2b48c");
        this.colorNameMap.put("brown", "#a52a2a");
        this.colorNameMap.put("white", "#ffffff");
        this.colorNameMap.put("mediumpurple", "#9370db");
    }

    public HashMap getColorNameMap() {
        return this.colorNameMap;
    }

    public StyleMapEntry parseAndAssignColors(String typeName, String featureValue, String labelString, String styleColor) {
        StyleMapEntry sme = new StyleMapEntry();
        sme.setAnnotationTypeName(typeName);
        sme.setFeatureValue(featureValue);
        sme.setLabel(labelString);
        StringTokenizer token = new StringTokenizer(styleColor, ":;");
        if (token.hasMoreTokens()) {
            token.nextToken();
            String fgString = token.nextToken().toLowerCase();
            if (fgString.startsWith("#")) {
                sme.setForeground(Color.decode(fgString));
            } else {
                String newFgString = (String)this.colorNameMap.get(fgString);
                if (newFgString != null) {
                    sme.setForeground(Color.decode(newFgString));
                } else {
                    sme.setForeground(Color.black);
                }
            }
            token.nextToken();
            String bgString = token.nextToken().toLowerCase();
            if (bgString.startsWith("#")) {
                sme.setBackground(Color.decode(bgString));
            } else {
                String newBgString = (String)this.colorNameMap.get(bgString);
                if (newBgString != null) {
                    sme.setBackground(Color.decode(newBgString));
                } else {
                    sme.setBackground(Color.white);
                }
            }
            this.parseChecked(token, sme);
            this.parseHidden(token, sme);
        }
        return sme;
    }

    private void parseChecked(StringTokenizer token, StyleMapEntry sme) {
        if (token.hasMoreTokens()) {
            String ck = token.nextToken();
            String tf = token.nextToken();
            if (ck.equals("checked")) {
                boolean checked = false;
                if (tf.equals("true")) {
                    checked = true;
                }
                sme.setChecked(checked);
            }
        } else {
            sme.setChecked(Boolean.TRUE);
        }
    }

    private void parseHidden(StringTokenizer token, StyleMapEntry sme) {
        if (token.hasMoreTokens()) {
            String ck = token.nextToken();
            String tf = token.nextToken();
            if (ck.equals("hidden")) {
                boolean checked = false;
                if (tf.equals("true")) {
                    checked = true;
                }
                sme.setHidden(checked);
            }
        } else {
            sme.setHidden(Boolean.FALSE);
        }
    }
}

